---
description: Tracking Page Setup and Usage
---

# Tracking Module Workflow

This workflow describes how to use and maintain the modern tracking system for customers.

### 1. Accessing the Tracking Page
The tracking page is available at `/track.php`. It is designed as a public-facing portal for customers to check shipment status without logging in.

### 2. Deep Linking
You can generate direct tracking links for customers using the following format:
`track.php?waybill=YOUR_WAYBILL_NUMBER`

### 3. Backend Logic
The tracking page relies on two main components:
- **Database**: `tbl_tracking` for scan history and `tbl_bookings` for shipment overview.
- **API**: `api/public/track_shipment.php` handles the data fetching for the frontend.

### 4. Updating Statuses
Statuses in the timeline are populated from `tbl_tracking`. When an update is received (via API or Manual update), a new record should be inserted into `tbl_tracking` to reflect in the customer's timeline.

### 5. Design Customization
The design uses:
- **Glassmorphism**: Backdrop blur and semi-transparent cards.
- **Dark Mode**: Optimized for high-end modern interfaces.
- **Typography**: Plus Jakarta Sans for a clean, professional aesthetic.
- **Icons**: Tabler Icons library.

// turbo
### 6. Health Check
To ensure the tracking API is functional, you can run a quick check:
```powershell
php api/public/track_shipment.php
```
(Expected: JSON error response "Waybill number is required")
