# Courier Partner Assignment Setup

## Overview
This document outlines the implementation of multi-select courier partner assignments for clients based on priority levels.

## Changes Made

### 1. Database Migrations

#### Migration 1: Add Priority and Assigned Couriers to Courier Partners
**File:** `database/migrations/add_priority_and_assigned_couriers.sql`

```sql
ALTER TABLE `tbl_courier_partner` ADD COLUMN `priority` INT(11);
ALTER TABLE `tbl_courier_partner` ADD COLUMN `assigned_couriers` LONGTEXT;
```

**Columns:**
- `priority` (INT): Priority level (1=DelhiVert, 2=Secondary, 3=Tertiary)
- `assigned_couriers` (LONGTEXT): JSON array of assigned courier partner IDs

#### Migration 2: Add Courier Assignments to Clients
**File:** `database/migrations/add_courier_assignments_to_client.sql`

```sql
ALTER TABLE `tbl_client` ADD COLUMN `courier_assignments` LONGTEXT;
```

**Column:**
- `courier_assignments` (LONGTEXT): JSON object mapping priority levels to courier partner IDs
  - Example: `{"1": "5", "2": "3", "3": "1"}`

### 2. Frontend Updates

#### client-add.php
- Hidden fields: Commission %, COD Amount, COD Percentage %, Minimum COD Amount
- These fields are now submitted as hidden inputs with value "0"

#### client-list.php
- **New Column:** "Assign Courier Partners"
- **New Modal:** `#assignClientCouriersModal`
- **Features:**
  - Displays 3 priority groups (DelhiVert, Secondary, Tertiary)
  - Radio buttons for selecting one courier per priority
  - Real-time visual feedback with color-coded borders
  - Selected couriers are highlighted

#### courier-partner-list.php
- **New Column:** "Priority" - Displays DelhiVert/Secondary/Tertiary
- **New Column:** "Assign Courier Partners" - Multi-select modal
- **New Modal:** `#assignCouriersModal`
- **Features:**
  - Left panel: Available couriers with checkboxes
  - Right panel: Real-time display of selected couriers
  - Assign multiple couriers to a partner

### 3. API Endpoints

#### New Endpoint: `api/client/update_courier_assignments.php`
**Method:** POST
**Content-Type:** application/json

**Request Body:**
```json
{
    "id": 1,
    "courier_assignments": {
        "1": "5",
        "2": "3",
        "3": "1"
    }
}
```

**Response:**
```json
{
    "status": "success",
    "message": "Courier assignments updated successfully",
    "data": {
        "id": 1,
        "courier_assignments": {...}
    }
}
```

### 4. Priority System

| Priority | Name | Courier Type |
|----------|------|--------------|
| 1 | DelhiVert (Primary) | Main courier partner |
| 2 | Secondary | Fallback option 1 |
| 3 | Tertiary | Fallback option 2 |

## Implementation Steps

### Step 1: Run Migrations
Execute the SQL migration files to add new columns:
```bash
1. database/migrations/add_priority_and_assigned_couriers.sql
2. database/migrations/add_courier_assignments_to_client.sql
```

### Step 2: Update Courier Partners
Set priority levels for existing courier partners:
```sql
UPDATE tbl_courier_partner SET priority = 1 WHERE partner_code = 'DELHIVERY_B2B';
UPDATE tbl_courier_partner SET priority = 2 WHERE partner_code = 'EKART';
UPDATE tbl_courier_partner SET priority = 3 WHERE partner_code = 'MOVIN';
```

### Step 3: Verify Files Are Updated
- ✅ client-add.php - Hidden fields
- ✅ client-list.php - Assignment modal and handlers
- ✅ courier-partner-list.php - Priority column and assignment modal
- ✅ api/client/update_courier_assignments.php - API endpoint created

## Usage

### Assigning Couriers to a Client

1. Go to **Client List**
2. Click **"Assign"** button in the "Assign Courier Partners" column
3. Select one courier for each priority level:
   - Priority 1 (DelhiVert): Primary courier
   - Priority 2 (Secondary): Fallback option
   - Priority 3 (Tertiary): Last resort option
4. Click **"Save Assignments"**

### Assigning Couriers to a Courier Partner

1. Go to **Courier Partner Setup**
2. Click **"Assign"** button in the "Assign Courier Partners" column
3. Check/uncheck couriers to assign multiple partners
4. Click **"Save Assignments"**

## Data Structure

### Client Courier Assignments (JSON)
```json
{
    "1": "5",    // Priority 1 → Courier Partner ID 5
    "2": "3",    // Priority 2 → Courier Partner ID 3
    "3": "1"     // Priority 3 → Courier Partner ID 1
}
```

### Courier Partner Assigned Couriers (JSON Array)
```json
["5", "3", "1", "2"]  // Array of assigned courier partner IDs
```

## Notes

- All assignments are stored as JSON for flexibility
- Priority levels are color-coded for easy identification
- Radio buttons enforce single selection per priority for clients
- Checkboxes allow multiple selections for courier partner assignments
- All changes are audit-tracked with updated_by and updated_at fields
