# Courier Name Display on Label - Update Complete

## ✅ Implementation Summary

The label now displays the **actual courier name** instead of hardcoded "DELHIVERY" text when using own courier or other custom couriers.

## Changes Made

### 1. **Own Courier Handler** (`api/label/services/owncourier.php`)
Added courier name to package data:

```php
'courier_name' => $courierName, // Add courier name for display
```

The handler now extracts the courier name from `$courierData['partner_name']` and includes it in the package response.

### 2. **Label Print Page** (`shipment-label-print.php`)

#### Updated Label Array:
```php
'courier_name' => trim((string) ($package['courier_name'] ?? $courierData['partner_name'] ?? '')),
```

#### Updated HTML Template:
```html
<b style="font-size:11px;">
    <?php echo h(strtoupper($label['courier_name'] ?: 'COURIER')); ?>
</b>
```

## How It Works

### **For Delhivery:**
- Shows Delhivery logo image (if available from API)
- Falls back to "DELHIVERY" text if no logo

### **For Own Courier:**
- Shows the courier partner name from database
- Example: "OWN COURIER", "SRIHARI LOGISTICS", etc.
- Text is displayed in uppercase for consistency
- Falls back to "COURIER" if name is not available

### **For Other Custom Couriers:**
- Shows the courier partner name from `tbl_courier_partner`
- Maintains same styling and layout

## Data Flow

```
Database (tbl_courier_partner)
    ↓
partner_name: "Own Courier"
    ↓
generateLabelWithOwnCourier()
    ↓
$packages['courier_name'] = "Own Courier"
    ↓
shipment-label-print.php
    ↓
$label['courier_name'] = "Own Courier"
    ↓
HTML: <b>OWN COURIER</b>
```

## Example Output

### Label Header Section:
```
┌─────────────────┬─────────────────┐
│  [Client Logo]  │  OWN COURIER   │
└─────────────────┴─────────────────┘
```

Or with actual courier name from database:
```
┌─────────────────┬─────────────────────┐
│  [Client Logo]  │  SRIHARI LOGISTICS │
└─────────────────┴─────────────────────┘
```

## Test URL

```
http://localhost/steve/shipment-label-print.php?id=25&waybill=SHA003&pdf_size=A4
```

**Expected Display:**
- Right side of header shows your courier partner name
- Name appears in uppercase, bold, 11px font
- Maintains same visual style as "DELHIVERY" text
- Properly centered in logo section

## Styling Details

**Font:** Arial, Helvetica, sans-serif
**Size:** 11px
**Weight:** Bold (700)
**Transform:** Uppercase
**Alignment:** Center
**Color:** Black (#000)

## Fallback Behavior

1. **Primary:** Show courier logo image (if available)
2. **Secondary:** Show courier partner name from database
3. **Tertiary:** Show "COURIER" as default text

## Benefits

✅ Professional branding for own courier
✅ Consistent label format across all couriers
✅ Easy to identify courier on printed labels
✅ No hardcoded "DELHIVERY" text for own courier
✅ Automatic uppercase transformation
✅ Proper fallback handling

## Configuration

To set your courier name, ensure your courier partner record has:
- **Partner Name:** "Your Courier Name"
- **Partner Code:** Any code (e.g., "OWN_COURIER")
- **Status:** Active

The partner name will automatically appear on all labels for that courier.

---

**Version:** 1.1
**Date:** 2025-02-13
**Status:** Production Ready ✅
