# Courier Partner Setup Module - Installation Guide

## ✅ Files Created

### Database
- `database/courier_partner_setup.sql` - Database table structure

### API Endpoints
- `api/courier_partner/create.php` - Create courier partner
- `api/courier_partner/read.php` - List all partners (DataTables)
- `api/courier_partner/read_single.php` - Get single partner
- `api/courier_partner/update.php` - Update partner
- `api/courier_partner/delete.php` - Delete partner

### Frontend Pages
- `courier-partner-list.php` - List view with filters
- `courier-partner-add.php` - Add/Edit form
- `courier-partner-view.php` - Profile-style view page

### Menu
- `sidebar.php` - Updated with "Courier Partner Setup" menu item

---

## 📋 Installation Steps

### Step 1: Create Database Table
Run the SQL file to create the table:
```sql
-- Navigate to phpMyAdmin or MySQL command line
-- Execute: database/courier_partner_setup.sql
```

Or manually run:
```bash
mysql -u root -p your_database_name < database/courier_partner_setup.sql
```

### Step 2: Set Up Permissions
Add permissions for the `courier_partner` module in your permission system:

**Module Name:** `courier_partner`

**Permissions Required:**
- `is_view` - View courier partners
- `is_add` - Add new courier partners
- `is_edit` - Edit existing courier partners
- `is_delete` - Delete courier partners

**Where to add:**
1. Go to your Role Management page
2. Add a new module called "Courier Partner Setup"
3. Enable the 4 permissions (View, Add, Edit, Delete)
4. Assign to appropriate roles

### Step 3: Test the Module
1. Navigate to **Settings → Courier Partner Setup** in the sidebar
2. You should see the list page with 4 sample partners (Delhivery B2B, Delhivery B2C, Ekart, Movin)
3. Test the following:
   - ✅ View a partner (click View button)
   - ✅ Add a new partner (click Add Courier Partner)
   - ✅ Edit a partner (click Edit button)
   - ✅ Delete a partner (click Delete button)
   - ✅ Filter by status (Active/Inactive)

---

## 🔑 Features Overview

### API Credentials Storage
The module stores the following credentials for each courier partner:

| Field | Type | Description |
|-------|------|-------------|
| Partner Name | Text | e.g., "Delhivery B2B" |
| Partner Code | Text | Unique code (e.g., "DELHIVERY_B2B") |
| API URL | URL | API endpoint URL |
| API Key | Text | API authentication key |
| Username | Text | API username |
| Password | Text | **Stored as plain text** (not encrypted) |
| Token | Text | Bearer/Access token |
| Client ID | Text | OAuth client ID |
| Client Secret | Text | OAuth client secret |
| Preference Order | Number | Priority (lower = higher priority) |
| Status | Enum | Active/Inactive |
| Remarks | Text | Additional notes |

### Security Note
⚠️ **Passwords are stored as plain text** as per your requirement. Consider:
- Restricting access to this module to admin users only
- Using HTTPS for all API communications
- Regular security audits

---

## 🎯 Usage Examples

### Example 1: Delhivery B2B Setup
```
Partner Name: Delhivery B2B
Partner Code: DELHIVERY_B2B
API URL: https://track.delhivery.com/api/cmu/create.json
API Key: [Your Delhivery API Key]
Username: [Your Username]
Password: [Your Password]
Preference Order: 1
Status: Active
```

### Example 2: Ekart Setup
```
Partner Name: Ekart Logistics
Partner Code: EKART
API URL: https://api.ekartlogistics.com/v1
Client ID: [Your Client ID]
Client Secret: [Your Client Secret]
Token: [Bearer Token]
Preference Order: 3
Status: Active
```

---

## 🔧 Customization

### Adding More Fields
If you need additional fields (e.g., `warehouse_id`, `account_number`):

1. **Update Database:**
   ```sql
   ALTER TABLE tbl_courier_partner 
   ADD COLUMN warehouse_id VARCHAR(100) DEFAULT NULL AFTER client_secret;
   ```

2. **Update API Files:**
   - Add field to `create.php` and `update.php`
   - Add to the INSERT/UPDATE queries

3. **Update Frontend:**
   - Add input field to `courier-partner-add.php`
   - Add display row to `courier-partner-view.php`

### Changing Preference Order Logic
The `preference_order` field determines priority:
- Lower number = Higher priority
- Use this in your booking logic to select the preferred courier

Example query to get active partners by preference:
```php
SELECT * FROM tbl_courier_partner 
WHERE status = 'active' 
ORDER BY preference_order ASC
LIMIT 1;
```

---

## 📞 Support

If you encounter any issues:
1. Check database connection in `config/config.php`
2. Verify permissions are set correctly
3. Check browser console for JavaScript errors
4. Review PHP error logs

---

## ✨ Next Steps

After setting up the module, you can:
1. Integrate with your booking system to auto-select courier partners
2. Add API testing functionality to verify credentials
3. Create a dashboard widget showing active/inactive partners
4. Add audit logs for credential changes
5. Implement API rate limiting per partner

---

**Module Version:** 1.0  
**Created:** 2026-02-10  
**Compatible with:** Steve Courier Management System
