# Delhivery Setup Guide for Pickup Points

## Step 1: Configure Delhivery Courier Partner

Navigate to: **Settings → Courier Partner Setup → Edit Delhivery**

Or directly: `courier-partner-add.php?id=1`

### Required Fields for Delhivery Integration

#### 1. **Partner Name**
- Value: `Delhivery` (case-sensitive)
- This exact name is used to identify Delhivery in the system

#### 2. **API URL (Base URL)**
Choose based on your environment:

**Staging Environment:**
```
https://staging-express.delhivery.com
```

**Production Environment:**
```
https://express.delhivery.com
```

#### 3. **Token**
- Your Delhivery API Token
- Format: `XXXXXXXXXXXXXXXXX` (without "Token" prefix)
- Example: `a1b2c3d4e5f6g7h8i9j0k1l2m3n4o5p6`
- Get this from your Delhivery account dashboard

### Optional Fields
- **Partner Code**: `DELHIVERY_B2B` or `DELHIVERY_B2C`
- **Preference Order**: Set priority (lower = higher priority)
- **Status**: Active
- **Remarks**: Any notes about this courier partner

---

## Step 2: Create Pickup Point

Navigate to: **Master Data Module → Pickup Points → Add New**

### Required Fields for Delhivery Sync

1. **Company** - Select the company
2. **Courier Partner** - Select "Delhivery"
3. **Pickup Point Name** - Warehouse name (case-sensitive!)
4. **Phone** - Contact number (mandatory)
5. **PIN Code** - Pickup location pincode (mandatory)
6. **Return Address** - Complete return address (mandatory)

### Important Notes

⚠️ **Warehouse Name is Case-Sensitive**
- Use the exact same name when creating orders
- Example: "Mumbai Warehouse" ≠ "mumbai warehouse"

⚠️ **Return Address is Mandatory**
- Can be same as pickup address
- Must include return_pin, return_city, return_state

---

## Step 3: Sync with Delhivery

1. Go to **Pickup Points List**
2. Find your newly created pickup point
3. Click the **"Sync"** button
4. Wait for confirmation

### Sync Status Indicators

- 🟢 **Green Badge "Synced"** - Successfully synced with Delhivery
- 🟡 **Yellow Badge "Not Synced"** - Not yet synced
- ⚪ **Gray Badge "N/A"** - Not a Delhivery courier

### Re-syncing

If you update pickup point details:
1. Edit the pickup point
2. Save changes
3. Click **"Re-sync"** button in the list

---

## Troubleshooting

### Error: "Authentication credentials were not provided"
**Solution:** Check that the Token is correctly entered in courier partner settings

### Error: "ClientWarehouse matching query does not exist"
**Solution:** 
- Verify the warehouse name matches exactly
- Check registered_name field
- Contact Delhivery support

### Error: "Client-Warehouse is not active"
**Solution:** Contact your Delhivery account POC to activate the warehouse

### Error: "Non serviceable pincode"
**Solution:** 
- Verify the pincode is in Delhivery's serviceable area
- Use Delhivery's pincode serviceability API first

### Sync button not showing
**Solution:**
- Ensure courier partner is set to "Delhivery" (exact name)
- Check you have edit permissions

---

## API Endpoint Details

### Warehouse Creation Endpoint
```
POST {api_url}/api/backend/clientwarehouse/create/
```

### Headers
```
Authorization: Token {your_token}
Content-Type: application/json
Accept: application/json
```

### Request Body (Auto-generated from pickup point data)
```json
{
  "phone": "9999999999",
  "city": "Mumbai",
  "name": "Mumbai Warehouse",
  "pin": "400001",
  "address": "123 Main Street, Andheri",
  "country": "India",
  "email": "warehouse@example.com",
  "registered_name": "Your Company Name",
  "return_address": "123 Main Street, Andheri",
  "return_pin": "400001",
  "return_city": "Mumbai",
  "return_state": "Maharashtra",
  "return_country": "India"
}
```

---

## Database Fields Reference

### Courier Partner Table (`tbl_courier_partner`)
- `partner_name` - Must be "Delhivery" for integration to work
- `api_url` - Base URL (staging or production)
- `token` - API authentication token

### Pickup Points Table (`tbl_pickup_points`)
- `courier_id` - Links to courier partner
- `delhivery_synced` - Boolean flag (0 = not synced, 1 = synced)
- `delhivery_response` - Stores last API response

---

## Quick Setup Checklist

- [ ] Add/Edit Delhivery courier partner
- [ ] Set partner_name to "Delhivery"
- [ ] Enter API URL (staging or production)
- [ ] Enter API Token
- [ ] Save courier partner
- [ ] Create new pickup point
- [ ] Select Delhivery as courier
- [ ] Fill all mandatory fields
- [ ] Save pickup point
- [ ] Click "Sync" button
- [ ] Verify green "Synced" badge appears

---

## Support

For Delhivery API issues:
- Contact: Your Delhivery Account POC
- Documentation: Delhivery API Docs
- Support: support@delhivery.com

For System Issues:
- Check error logs in `delhivery_response` field
- Review API response in database
- Contact development team

---

**Last Updated:** 2026-02-10  
**Version:** 1.0
