# HRM Module - Quick Start Guide

## 🚀 Getting Started with HRM Module

### Step 1: Run Database Migration

Execute the SQL migration script to create all required tables:

```sql
-- Location: database/migrations/hrm_extensions.sql
-- Run this script in your MySQL database: srihari
```

This will create:
- `tbl_salary_templates` (with 4 sample templates)
- `tbl_employee_salary_templates`
- `tbl_shifts` (with 4 pre-configured shifts)
- `tbl_employee_shifts`
- `tbl_attendance`
- `tbl_attendance_summary`
- `tbl_payroll`
- `tbl_payroll_adjustments`

---

### Step 2: Access HRM Modules

All HRM modules are now accessible from the sidebar under **"HR Management"**:

```
📂 HR Management
├── 💰 Salary Templates (salary-template-list.php)
├── 📋 Salary Assignment (employee-salary-assign.php)
├── 🔄 Shift Management (shift-list.php)
├── 📊 Attendance Tracking (attendance-list.php)
└── 💳 Payroll Processing (payroll-list.php)
```

---

## 📝 Complete Workflow

### 1️⃣ Setup Salary Templates

**Navigate to**: HR Management → Salary Templates

**Action**: Create salary templates for different employee levels

**Pre-configured Templates**:
- Junior Level: ₹25,000 basic
- Senior Level: ₹50,000 basic
- Manager Level: ₹75,000 basic
- Executive Level: ₹1,00,000 basic

**To Add New**:
- Click "Add New Template"
- Fill in salary components and deductions
- Save template

---

### 2️⃣ Assign Salary to Employees

**Navigate to**: HR Management → Salary Assignment

**Action**: Assign appropriate salary template to each employee

**Steps**:
1. Select Employee
2. Choose Salary Template
3. Set Assignment Date
4. Set Effective Date (when salary becomes active)
5. Save Assignment

---

### 3️⃣ Configure Shifts (Optional)

**Navigate to**: HR Management → Shift Management

**Pre-configured Shifts**:
- **Morning Shift**: 6:00 AM - 2:00 PM (₹0 allowance)
- **Evening Shift**: 2:00 PM - 10:00 PM (₹100 allowance)
- **Night Shift**: 10:00 PM - 6:00 AM (₹200 allowance)
- **Flexible Shift**: 9:00 AM - 5:00 PM (₹0 allowance)

**To Add Custom Shift**:
1. Click "Add New Shift"
2. Enter shift name
3. Set start and end time
4. Set break duration (minutes)
5. Set shift allowance (₹)
6. Save shift

---

### 4️⃣ Mark Daily Attendance

**Navigate to**: HR Management → Attendance Tracking

**Steps**:
1. Click "Mark Attendance"
2. Select Employee
3. Select Date
4. Choose Status:
   - **Present** ✅
   - **Absent** ❌
   - **Leave** 🏖️
   - **Half Day** ⏰
   - **Weekend** 🌴
   - **Holiday** 🎉
5. Assign Shift (if applicable)
6. Enter Check-in and Check-out time
7. Add notes (optional)
8. Save Attendance

**Bulk Attendance**:
- Use filters to view attendance by date range
- Filter by employee, status
- Edit or delete as needed

---

### 5️⃣ Generate Monthly Payroll

**Navigate to**: HR Management → Payroll Processing

**Steps to Generate Payroll**:

1. Click "Generate Payroll"
2. Select Employee
3. Select Month/Year
4. Click "Calculate Payroll"

**Auto-Calculation Process**:
The system automatically:
- Counts working days in the month
- Fetches attendance records
- Calculates present days, absent days, leave days, half days
- Sums up shift allowances
- Calculates proportionate salary
- Applies deductions
- Computes net salary

**Payroll Formula**:
```
Working Days = Total days in month (e.g., 30)
Attendance Days = Present + Leave + (Half Day × 0.5)

Per Day Salary = Gross Salary ÷ Working Days
Earned Salary = Per Day Salary × Attendance Days
Shift Allowance = Sum of all shift allowances for attended days

Net Salary = Earned Salary + Shift Allowance - Total Deductions
```

5. Review calculated payroll
6. Click "Save Payroll" (saves as **Draft**)

**Payroll Workflow**:
```
Draft → Approved → Paid
```

- **Draft**: Editable, can be deleted
- **Approved**: Locked, ready for payment
- **Paid**: Payment completed

---

## 📊 Payroll Management

### Approve Payroll

**Navigate to**: HR Management → Payroll Processing

1. Find draft payroll
2. Click "Approve" button
3. Payroll status changes to **Approved**
4. Approval timestamp recorded

### Mark as Paid

1. Find approved payroll
2. Click "Mark Paid" button
3. Payroll status changes to **Paid**
4. Payment date recorded

### Delete Draft Payroll

- Only **Draft** payrolls can be deleted
- Approved/Paid payrolls cannot be deleted

---

## 🔍 Filters and Reports

### Attendance Filters

- **Date Range**: From Date - To Date
- **Employee**: Filter by specific employee
- **Status**: Filter by attendance status

### Payroll Filters

- **Month/Year**: Filter by payroll month
- **Employee**: Filter by specific employee
- **Status**: Filter by Draft/Approved/Paid

---

## 💡 Tips and Best Practices

### Attendance Management

✅ **DO**:
- Mark attendance daily for accurate payroll
- Use half-day status for partial attendance
- Assign shifts for employees working non-standard hours
- Add notes for special circumstances

❌ **DON'T**:
- Don't mark duplicate attendance for same date
- Don't delete attendance without backup

### Payroll Processing

✅ **DO**:
- Generate payroll at the end of each month
- Review calculated amounts before saving
- Approve only after verification
- Mark as paid only after actual payment

❌ **DON'T**:
- Don't generate payroll without attendance data
- Don't approve without review
- Don't delete approved payroll

---

## 📂 File Structure Reference

```
Frontend Pages:
├── salary-template-list.php    (List all salary templates)
├── salary-template-add.php     (Create/Edit salary template)
├── employee-salary-assign.php  (Assign salary to employees)
├── shift-list.php              (List all shifts)
├── shift-add.php               (Create/Edit shift)
├── attendance-list.php         (List all attendance)
├── attendance-add.php          (Mark attendance)
├── payroll-list.php            (List all payrolls)
└── payroll-generate.php        (Generate payroll)

API Endpoints:
├── api/salary_template/        (CRUD for salary templates)
├── api/employee_salary_assignment/  (CRUD for assignments)
├── api/shift/                  (CRUD for shifts)
├── api/attendance/             (CRUD for attendance)
└── api/payroll/                (Payroll management)
    ├── calculate.php           (Auto-calculate payroll)
    ├── create.php              (Save payroll)
    ├── read.php                (List payrolls)
    ├── update_status.php       (Approve/Mark Paid)
    └── delete.php              (Delete draft)
```

---

## 🎯 Example Scenario

### Complete Monthly HR Process

**Month**: January 2026

#### Week 1-4: Daily Operations

**Every Day**:
1. Go to Attendance Tracking
2. Mark attendance for all employees
3. Assign shifts if needed
4. Record check-in/check-out times

#### End of Month: Payroll Processing

**January 31st**:

1. **Generate Payroll**:
   - Navigate to Payroll Processing
   - Click "Generate Payroll"
   - Select first employee: "John Doe"
   - Select month: "2026-01"
   - Click "Calculate Payroll"

2. **System Auto-Calculates**:
   - Working Days: 31
   - Attendance Days: 28 (Present: 26, Leave: 2)
   - Basic Salary: ₹50,000
   - HRA: ₹10,000
   - DA: ₹5,000
   - Allowances: ₹4,500
   - Gross Salary: ₹69,500
   - Per Day Salary: ₹2,241.94
   - Earned Salary: ₹62,774.19
   - Shift Allowance: ₹800 (4 night shifts)
   - Total Deductions: ₹10,000
   - **Net Salary**: ₹53,574.19

3. **Review and Save**:
   - Verify all calculations
   - Click "Save Payroll" (Status: Draft)

4. **Approval**:
   - Go to Payroll List
   - Click "Approve" for John Doe's payroll
   - Status changes to "Approved"

5. **Payment**:
   - After actual payment is made
   - Click "Mark Paid"
   - Status changes to "Paid"
   - Paid date recorded

6. **Repeat** for all employees

---

## 🆘 Troubleshooting

### Issue: Payroll shows ₹0 net salary

**Solution**: Ensure attendance is marked for the selected month

### Issue: Cannot delete payroll

**Solution**: Only Draft payrolls can be deleted. Approved/Paid cannot be deleted.

### Issue: Shift allowance not calculating

**Solution**: Ensure shift is assigned to the attendance record

### Issue: Employee not showing in dropdown

**Solution**: Check if employee status is "Active" and assigned to a branch

---

## 📞 Support

For any issues or questions:
- Check `HRM_MODULE_COMPLETION_SUMMARY.md` for technical details
- Review `projectskill.md` for system architecture
- Check browser console for JavaScript errors
- Check server error logs for PHP errors

---

**Last Updated**: 2026-02-16
**Version**: 1.0
**Status**: Production Ready ✅
