# Own Booking/Shipment Creation Guide

## 📌 Overview

This guide covers creating bookings and shipments for **"Own Courier"** (internal/proprietary courier service) and how they integrate with the status update system.

---

## 🎯 Understanding the System

### Key Concepts

**Booking** vs **Shipment**:
- **Booking**: Order/Request from customer (metadata)
- **Shipment**: Physical package being delivered (detailed tracking)
- **Own Courier**: Your company's internal delivery service

### Data Flow

```
Customer Order
    ↓
Create Booking (tbl_bookings)
    ↓
Create Shipment Package Details (tbl_shipments)
    ↓
Assign Courier (Own Courier = ID 2 typically)
    ↓
Manual Status Updates (tbl_tracking)
    ↓
Final Delivery
```

---

## 📋 Required Information

### 1. CONSIGNEE (Recipient) DETAILS
```
Name               ⭐ Required
Phone              ⭐ Required
Address            ⭐ Required
Pincode            ⭐ Required
City               (Auto-determined from pincode)
State              (Auto-determined from pincode)
Country            (Default: India)
Email              (Optional)
GST Number         (Optional, for B2B)
```

### 2. CONSIGNOR (Shipper/Sender) DETAILS
```
Name               ⭐ Required
Phone              ⭐ Required
Address            ⭐ Required
Pincode            ⭐ Required
City               (Auto-determined from pincode)
State              (Auto-determined from pincode)
```

### 3. PACKAGE DETAILS (Per Box)
```
Length             ⭐ Required (in cm)
Width              ⭐ Required (in cm)
Height             ⭐ Required (in cm)
Number of Boxes    ⭐ Required
Actual Weight      ⭐ Required (in kg)
Charged Weight     ⭐ Required (in kg, typically > actual)
Description        (What's inside)
```

### 4. SHIPMENT DETAILS
```
Payment Mode       ⭐ Required (Prepaid / COD)
COD Amount         (If COD selected)
Invoice Number     ⭐ Required
Invoice Value      ⭐ Required
Shipping Mode      ⭐ Required (Surface/Air)
E-way Bill         (Optional)
```

### 5. RETURN ADDRESS (If Lost/Damaged)
```
Name               (Default: Same as Consignor)
Phone              (Default: Same as Consignor)
Address            (Default: Same as Consignor)
```

---

## 🚀 Step-by-Step Creation

### STEP 1: Select Pickup Point
```
1. Click "Create Shipment" in main menu
2. Select Branch (organizational unit)
3. Select Pickup Point under that branch
   ├─ Auto-fills: Your Company Name, Address, Phone
   └─ These become the Consignor/Shipper details
```

### STEP 2: Fill Consignee Details
```
1. Enter Recipient Name
2. Enter Recipient Phone
3. Enter Recipient Address
4. Enter Recipient Pincode
   ├─ City auto-fills from pincode
   └─ State auto-fills from pincode
5. (Optional) Email, GST Number
```

### STEP 3: Add Package Details
```
1. Click "Add Package" button
2. Enter Length (cm)
3. Enter Width (cm)
4. Enter Height (cm)
5. Enter Number of Boxes
6. Enter Actual Weight (kg)
7. Enter Charged Weight (kg)
8. (Optional) Description
9. Click "Save Package"
10. Repeat for multiple packages
```

**Example Package**:
```
┌─────────────────────────┐
│ Package #1              │
├─────────────────────────┤
│ Dimensions: 20 x 15 x 10 cm
│ Boxes: 1
│ Actual Weight: 2.5 kg
│ Charged Weight: 3 kg
│ Description: Clothing items
└─────────────────────────┘
```

### STEP 4: Select Courier & Payment
```
1. Courier: Select "Own Courier"
2. Payment Mode: Select "Prepaid" or "COD"
   ├─ If COD: Enter amount
   └─ If Prepaid: Leave blank
```

### STEP 5: Invoice & Shipping Info
```
1. Invoice Number: Enter invoice ID
2. Invoice Value: Enter total amount
3. Shipping Mode: Select "Surface" or "Air"
4. E-way Bill: (Optional)
```

### STEP 6: Create Booking
```
1. Click "Create Shipment" button
2. System generates:
   ├─ Booking ID
   ├─ Reference ID (ORD-timestamp)
   └─ (Optional) AWB if available
3. See success confirmation
4. Shipment ready for status updates
```

---

## 📊 Database Tables Affected

### tbl_bookings (Main Booking Record)
```sql
INSERT INTO tbl_bookings (
  courier_id,           -- ID for "Own Courier"
  booking_ref_id,       -- ORD-timestamp or custom
  pickup_point_id,      -- Selected pickup point
  consignee_name,       -- Recipient
  consignee_phone,
  consignee_address,
  consignee_pincode,
  consignee_city,
  consignee_state,
  shipper_name,         -- Pickup point/Consignor
  shipper_phone,
  shipper_address,
  shipper_city,
  shipper_state,
  payment_mode,         -- Prepaid/COD
  cod_amount,
  invoice_no,
  invoice_value,
  last_status,          -- Initially "Pending"
  created_by,
  created_at
)
```

### tbl_shipments (Package Details)
```sql
INSERT INTO tbl_shipments (
  booking_id,           -- Links to tbl_bookings
  length,               -- Per package
  width,
  height,
  boxes,
  actual_weight,
  charged_weight,
  product_desc,
  created_at
)
```

---

## 🔗 API Endpoint

### Create Booking/Shipment
```
POST /api/shipment/create.php
```

### Required POST Parameters:
```
courier_id           ⭐ 2 (for Own Courier)
pickup_point_id      ⭐ Selected pickup ID
booking_ref_id       (auto-generated if empty)

// Consignee
consignee_name       ⭐
consignee_phone      ⭐
consignee_address    ⭐
consignee_pin        ⭐
consignee_city
consignee_state
consignee_email
consignee_gst

// Consignor (from pickup)
shipper_name         ⭐
shipper_phone        ⭐
shipper_address      ⭐
shipper_pin          ⭐
shipper_city
shipper_state

// Packages (arrays)
length[]             ⭐
width[]              ⭐
height[]             ⭐
boxes[]              ⭐
actual_weight[]      ⭐
charged_weight[]     ⭐
product_desc[]

// Invoice & Payment
payment_mode         ⭐ (Prepaid/COD)
cod_amount
shipping_mode        ⭐ (Surface/Air)
invoice_no           ⭐
invoice_value        ⭐
ewaybill_no

// Return Address (defaults to shipper)
rto_name
rto_phone
rto_address
```

### Response:
```json
{
  "status": "success",
  "booking_id": 12345,
  "booking_ref_id": "ORD-1708950234",
  "waybill_no": "AWS123456",
  "message": "Booking created successfully"
}
```

---

## 🎨 Own Courier Specifics

### What is "Own Courier"?
```
Your company's internal delivery service:
- Not using Delhivery, Ecom Express, etc.
- Manual tracking via this system
- Status updates done manually (Status Update page)
- No automated API syncing
```

### Own Courier Workflow:
```
1. CREATE BOOKING
   ↓
2. ASSIGN AWB NUMBER (manually or auto)
   ↓
3. PICKUP PICKUP (status: Not Picked → Picked)
   ↓
4. ADD TO MANIFEST (status: Pending → Manifested)
   ↓
5. HANDOVER TO DRIVER (status: In Transit)
   ↓
6. DELIVERY ATTEMPT (status: Out For Delivery)
   ↓
7. FINAL STATUS:
   ├─ Delivered
   ├─ RTO (Return to Origin)
   └─ LOST (if missing)
```

### Status Update for Own Courier:
```
Use: shipment-status-update.php
1. Scan AWB number
2. Select new status
3. Add location/remarks
4. Save to tbl_tracking
5. Updates last_status in tbl_bookings
```

---

## 💾 Sample Data

### Example Booking Creation:

**Consignee**:
```
Name: John Smith
Phone: 9876543210
Address: 123 Main Street, Apt 4B
Pincode: 400001
City: Mumbai
State: Maharashtra
```

**Consignor** (Auto-filled from Pickup):
```
Name: ABC Logistics Pvt Ltd
Phone: 9988776655
Address: Logistics Hub, Industrial Area
Pincode: 110001
City: Delhi
State: Delhi
```

**Packages**:
```
Package 1:
- Dimensions: 30 x 20 x 15 cm
- Boxes: 2
- Actual Weight: 5 kg
- Charged Weight: 5.5 kg

Package 2:
- Dimensions: 25 x 25 x 10 cm
- Boxes: 1
- Actual Weight: 2 kg
- Charged Weight: 2.5 kg
```

**Invoice & Payment**:
```
Payment Mode: Prepaid
Invoice Number: INV-2024-001
Invoice Value: 5000
Shipping Mode: Surface
```

---

## 🔍 Verification After Creation

### Check in Database:
```sql
-- See the booking
SELECT * FROM tbl_bookings
WHERE booking_ref_id = 'ORD-xxx'
AND courier_id = 2;

-- See package details
SELECT * FROM tbl_shipments
WHERE booking_id = 12345;

-- No tracking yet (will be added manually)
SELECT * FROM tbl_tracking
WHERE booking_id = 12345;
```

### Check in UI:
```
1. Go to "Shipment List"
2. Search by Reference ID or AWB
3. Verify all details display correctly
4. Status should be "PENDING"
```

---

## ✏️ Edit Booking

### Before AWB Assignment:
```
Can Edit:
- Consignee details
- Consignor details
- Package details
- Invoice details
- Payment mode
```

### After AWB Assignment:
```
Cannot Edit:
- Consignee details
- Consignor details
- Invoice number
- Package dimensions

Can Still Edit:
- Product description
- Remarks
- RTO address
```

---

## 🗑️ Delete/Cancel Booking

```
Status: PENDING → Can delete completely
Status: MANIFESTED+ → Can only mark as cancelled
        (Audit trail preserved)
```

---

## 📌 Integration with Status Update

### Once Booking Created:

```
1. Booking visible in "Shipment List"
2. Can be searched in "Status Update" page
3. Track status changes in real-time
4. History visible with all scans
```

### Status Update Process:
```
shipment-status-update.php
    ↓
1. Scan AWB → Finds booking
2. Shows current details
3. Select new status
4. Creates tbl_tracking record
5. Updates tbl_bookings.last_status
```

---

## 🎯 Common Statuses for Own Courier

| Status | Meaning | When Used |
|:---|:---|:---|
| PENDING | Booking created, not yet picked | Initial state |
| NOT PICKED | Failed to pickup from shipper | Pickup issue |
| MANIFESTED | Added to shipping manifest | Ready to ship |
| IN TRANSIT | With transport | On the way |
| OUT FOR DELIVERY | With last-mile delivery agent | In delivery area |
| DELIVERED | Successfully delivered | Order complete |
| LOST | Package lost in transit | Issue reported |
| RTO | Return to origin (refund) | Customer rejected |

---

## 🔐 Permissions

```
Create Shipment:  require_permission('shipment', 'is_add')
Edit Shipment:    require_permission('shipment', 'is_update')
Delete Shipment:  require_permission('shipment', 'is_delete')
View Shipment:    require_permission('shipment', 'is_view')
Update Status:    require_permission('shipment', 'is_update')
```

---

## 🐛 Common Issues & Solutions

| Issue | Cause | Solution |
|:---|:---|:---|
| Missing pickup point | Not selected | Select pickup point first |
| Consignee pin not found | Invalid pincode | Use valid Indian pincode |
| AWB already exists | Duplicate entry | Change booking ref ID |
| Can't update status | Missing permission | Contact admin for access |
| Status not saving | Database error | Check error message, retry |

---

## 📈 Workflow Diagram

```
┌─────────────────────────────────────────────────────┐
│           CREATE OWN BOOKING WORKFLOW                │
└─────────────────────────────────────────────────────┘

START
  ↓
[Select Branch]
  ↓
[Select Pickup Point]
  ├─ Auto-fill: Shipper details
  └─ Auto-fill: Courier = Own Courier
  ↓
[Enter Consignee Details]
  ├─ Name, Phone, Address ⭐
  └─ Pincode (auto city/state)
  ↓
[Add Package(s)]
  ├─ Dimensions, Weight, Boxes
  └─ Can add multiple packages
  ↓
[Select Payment Mode]
  ├─ Prepaid / COD
  └─ If COD: Enter amount
  ↓
[Enter Invoice Details]
  ├─ Invoice No., Value ⭐
  └─ Shipping Mode (Surface/Air)
  ↓
[CREATE BOOKING]
  ├─ System generates booking ID
  ├─ Reference ID assigned
  └─ Ready for tracking
  ↓
[CONFIRM SUCCESS]
  ├─ Show booking details
  └─ Copy to Shipment List
  ↓
[UPDATE STATUS]
  └─ Use Status Update page for manual updates
  ↓
[DELIVERY & COMPLETION]
  ↓
END
```

---

## 📞 Support Info

**Document Version**: 1.0
**Last Updated**: 2026-02-14
**Integration Level**: Full (with Status Update System)

### Related Pages:
- `shipment-create.php` - Main creation form
- `shipment-list.php` - View all bookings
- `shipment-status-update.php` - Update status manually
- `api/shipment/create.php` - Backend API
- `api/tracking/create.php` - Status tracking API
