# Own Courier Label Setup Guide

## ✅ Implementation Complete

The system now supports label printing for **Own Courier** shipments without requiring external API integration.

## How It Works

### 1. **Automatic Detection**
When you print a label, the system automatically detects the courier type:
- **Delhivery/External Couriers**: Fetches label data from courier API
- **Own Courier/Unmatched**: Generates label data directly from your booking database

### 2. **Own Courier Handler**
File: `api/label/services/owncourier.php`

**Features:**
- Reads booking data directly from `tbl_bookings` table
- No external API calls needed
- Generates Delhivery-compatible label format
- Supports all label sections (ship to, seller, products, etc.)
- Works with existing `shipment-label-print.php` template

### 3. **Courier Registry**
File: `api/label/services/courier_service.php`

**Registry Entries:**
```php
[
    'code_prefix' => 'DEL',
    'name_contains' => 'delhivery',
    'handler' => 'generateLabelWithDelhivery'
],
[
    'code_prefix' => 'OWN',
    'name_contains' => 'own',
    'handler' => 'generateLabelWithOwnCourier'
]
```

**Fallback:** Any courier not matching the registry will automatically use the Own Courier handler.

## Usage

### From Shipment List
1. Navigate to **Booking → Booking List**
2. Find your "Own Courier" shipment
3. Click **"Print Label"** button
4. Label opens in new window with all booking data
5. Print dialog appears automatically

### Direct URL Access
```
shipment-label-print.php?id=25&waybill=SHA003&pdf_size=A4
```

**Parameters:**
- `id` - Booking ID from database
- `waybill` - Waybill number (e.g., SHA003)
- `pdf_size` - Label size (A4 or 4R)

## Label Data Mapping

The own courier handler maps database fields to label format:

| Label Field | Database Source |
|-------------|----------------|
| Waybill Number | `b.waybill_no` |
| Ship To Name | `b.consignee_name` |
| Ship To Address | `b.consignee_address` |
| Ship To City/State | `b.consignee_city`, `b.consignee_state` |
| PIN Code | `b.consignee_pin` |
| Payment Mode | `b.payment_mode` (COD/Prepaid) |
| COD Amount | `b.cod_amount` |
| Invoice Value | `b.invoice_value` |
| Product | `b.product_desc` |
| Seller Name | `p.name` or `co.company_name` |
| Seller Address | `p.address`, `p.city`, `p.pin` |
| Order ID | `b.booking_ref_id` |
| Return Address | `b.rto_address` or pickup address |
| Date | `b.created_at` |

## Courier Partner Setup

To use as "Own Courier", create a courier partner with:

**Partner Code:** `OWN_COURIER` (or any code starting with "OWN")
**Partner Name:** "Own Courier" (or name containing "own")
**Status:** Active

**No API credentials needed** - the system will automatically use the database handler.

## Adding More Custom Couriers

To add support for another custom courier:

1. **Create Handler File:**
   ```php
   // api/label/services/mycourier.php
   function generateLabelWithMyCourier($courierData, $labelInput) {
       // Your custom logic
   }
   ```

2. **Register in courier_service.php:**
   ```php
   $LABEL_COURIER_REGISTRY = [
       ['code_prefix' => 'MYC', 'name_contains' => 'mycourier',
        'file' => 'mycourier.php', 'handler' => 'generateLabelWithMyCourier'],
   ];
   ```

3. **Done!** The system will automatically route to your handler.

## Error Handling

**Common Issues:**

1. **"Booking not found"**
   - Verify waybill number exists in database
   - Check `tbl_bookings.waybill_no` column

2. **"Label service not configured"**
   - ✅ **Fixed!** Now uses fallback handler automatically

3. **Missing data on label**
   - Ensure booking has complete consignee/pickup data
   - Check company logo path in `tbl_company`

## Benefits

✅ No API integration needed for own courier
✅ Instant label generation from database
✅ Same professional label format as Delhivery
✅ Automatic fallback for unmatched couriers
✅ Easy to add more custom courier handlers
✅ Works with existing shipment list workflow

## Testing

Test URL:
```
http://localhost/steve/shipment-label-print.php?id=25&waybill=SHA003&pdf_size=A4
```

**Expected Result:**
- Label displays with all booking data
- Company logo appears (if configured)
- Barcode shows SHA003
- All address details populate from database
- Print dialog opens automatically

## Support

If labels still don't work:
1. Check database has complete booking data
2. Verify courier_id in booking matches courier partner
3. Ensure waybill_no is not empty
4. Check PHP error logs for detailed messages

---

**Version:** 1.0
**Date:** 2025-02-13
**Status:** Production Ready ✅
