# Shipment Status Update - Quick Reference

## 🚀 Quick Start (30 seconds)

### Access the Page
```
URL: http://localhost/steve/shipment-status-update.php
```

### Update a Shipment (3 steps)
1. **Search:** Type AWB number → Click Search or press Enter
2. **Update:** Select status, add location and remarks
3. **Save:** Click "Update Status"

---

## 📍 File Locations

| File | Purpose |
|------|---------|
| `shipment-status-update.php` | Main feature page |
| `api/tracking/create.php` | Save status update |
| `api/shipment/read.php` | Get shipments list |
| `api/tracking/read.php` | Get tracking history |
| `test-shipment-update.php` | Test all APIs |

---

## 🎯 What Each Button Does

| Button | Action |
|--------|--------|
| **Search** | Find shipment by AWB/ID/Reference |
| **Update Status** | Save new status to database |
| **Back to Shipment List** | Return to shipment list page |

---

## 📋 Status Options

```
- Pending
- Not Picked
- Manifested
- In Transit
- Out For Delivery
- Delivered
- LOST
- RTO (Return To Origin)
```

---

## 🔍 Search Methods

### By AWB Number
```
AWB123456 → Search
```

### By Booking Reference
```
REF001 → Search
```

### By Booking ID
```
1 → Search
```

### Using Enter Key
```
AWB123456 + Press Enter
```

---

## 📊 Database Queries

### Check Recent Updates
```sql
SELECT * FROM tbl_tracking ORDER BY created_at DESC LIMIT 5;
```

### Check Shipment Status
```sql
SELECT id, waybill_no, last_status, updated_at 
FROM tbl_bookings 
WHERE id = 123;
```

### Check History for Shipment
```sql
SELECT * FROM tbl_tracking 
WHERE booking_id = 123 
ORDER BY scan_datetime DESC;
```

### Count Updates Today
```sql
SELECT COUNT(*) FROM tbl_tracking 
WHERE DATE(created_at) = CURDATE();
```

---

## 🧪 Test the Feature

### URL
```
http://localhost/steve/test-shipment-update.php
```

### What to Test
1. ✅ Get all shipments
2. ✅ Search single shipment
3. ✅ Create tracking record
4. ✅ Get tracking history
5. ✅ Check database schema

---

## 🎨 UI Layout

```
┌─────────────────────────────────────────┐
│  Scan AWB Number [Input Field] [Search] │
├─────────────────────────────────────────┤
│  Shipments Table (13 columns)           │
│  # | AWB | Boxes | Pay | Date | Status │
│  ──────────────────────────────────────  │
│  1 | AWB... | ... | ₹ | Date | Status │
│  [Update Button]                        │
├─────────────────────────────────────────┤
│  Status Update Form (Hidden until click)│
│  Status [Dropdown]  Date [Input]        │
│  Location [Input]   [Update Button]     │
│  Remarks [Text Area]                    │
├─────────────────────────────────────────┤
│  Tracking History (Hidden until update) │
│  Date | Status | Location | Remarks    │
└─────────────────────────────────────────┘
```

---

## 🔗 API Quick Reference

### Get Shipments
```javascript
GET /api/shipment/read.php?length=-1
```

### Create Tracking
```javascript
POST /api/tracking/create.php
Data: {
  booking_id: 1,
  status: "In Transit",
  status_date: "2024-01-15T14:30",
  location: "Delhi Hub",
  remarks: "Optional notes"
}
```

### Get History
```javascript
GET /api/tracking/read.php?id=1
```

### Get Branches
```javascript
GET /api/branch/read.php?length=-1
```

---

## 💾 Data Flow

```
1. User enters AWB number
         ↓
2. Frontend sends to api/shipment/read.php
         ↓
3. API returns shipment data
         ↓
4. Form displays for update
         ↓
5. User selects status, date, location
         ↓
6. Clicks "Update Status"
         ↓
7. Frontend sends to api/tracking/create.php
         ↓
8. API validates data
         ↓
9. Insert into tbl_tracking
         ↓
10. Update tbl_bookings.last_status
         ↓
11. Return success response
         ↓
12. Frontend reloads tracking history
         ↓
13. Display updated records
```

---

## ⚙️ Configuration

### Required Fields
```
- Booking ID (database)
- Status (required in form)
- Status Date (required in form)
```

### Optional Fields
```
- Location
- Remarks
```

### Default Values
```
- Date: Today
- Status: Dropdown (user selects)
- Location: Empty
- Remarks: Empty
```

---

## 🛠️ Troubleshooting

| Problem | Solution |
|---------|----------|
| Page blank | Check header.php & footer.php |
| Shipment not found | Verify AWB in database |
| Update fails | Check browser console for errors |
| No history | First update creates first record |
| Filter not working | Check branch_id in database |

---

## 📞 Common Tasks

### Task: View all updates for a shipment
1. Search shipment
2. Scroll down to "Scan/Type History"
3. View all previous status updates

### Task: Find shipment by reference
1. Search using booking reference (REF001)
2. Or search by booking ID (1)

### Task: Check last update time
1. Search shipment
2. View tracking history
3. First row = most recent update

### Task: Export tracking data
```sql
SELECT * FROM tbl_tracking 
WHERE booking_id = 123 
ORDER BY scan_datetime DESC;
-- Copy to Excel/CSV
```

---

## 📱 Mobile View

- Search input: Full width
- Update form: Stacked vertically
- Table: Horizontally scrollable
- Buttons: Touch-friendly (large tap area)

---

## 🔐 Permissions

The feature checks for `shipment`, `is_view`, and `is_update` permissions. Make sure your user has appropriate roles assigned.

---

## 📝 Status Update Rules

1. Status must be selected from dropdown
2. Date must be valid
3. Cannot update future dates
4. Duplicate updates prevented (same status + datetime)
5. All updates logged with user_id and timestamp

---

## ✅ Verification Checklist

Before using in production:

- [ ] Database schema verified
- [ ] All API endpoints tested
- [ ] Page loads without errors
- [ ] Search functionality works
- [ ] Status update creates database record
- [ ] Tracking history displays correctly
- [ ] Filters work (Status, Branch)
- [ ] Responsive on mobile
- [ ] User permissions configured
- [ ] Error messages display correctly

---

## 📚 Related Documentation

- `IMPLEMENTATION_COMPLETE.md` - Full technical details
- `SHIPMENT_STATUS_UPDATE_VERIFICATION.md` - Testing checklist
- `OWN_COURIER_STATUS_UPDATE.md` - Feature documentation
- `USAGE_GUIDE_STATUS_UPDATE.md` - User manual

---

## 🎓 Key Concepts

**Shipment:** A single package/delivery (identified by AWB number or booking ID)

**Status:** Current state of shipment (Pending, In Transit, Delivered, etc.)

**Tracking Record:** A history entry when status changes

**Tracking History:** All status changes for a shipment

**AWB Number:** Airway Bill number (unique identifier)

**Booking Reference:** Alternative identifier (REF001, etc.)

---

**Last Updated:** January 2024  
**Version:** 1.0  
**Status:** Ready to Use ✅
