# Shipment Creation & Status Update: Visual Summary

This document illustrates the end-to-end workflow between **Shipment Creation**, **Bulk Status Updates**, and the underlying **Database Tracking System**.

---

## 🏗️ 1. Architecture Overview (The "Fix" Connection)

The system bridges two main interfaces via a unified tracking API. Every status update entered manually is appended as a new record in `tbl_tracking` while updating the "master" status in `tbl_bookings`.

### Workflow Flowchart
1.  **Creation** (`shipment-create.php`): Generates a record in `tbl_bookings`.
2.  **Tracking Interface** (`shipment-status-update.php`): Scans AWB and adds shipments to an interactive list.
3.  **API Update** (`api/tracking/create.php`): Processed bulk updates, inserting into `tbl_tracking` and refreshing `tbl_bookings.last_status`.

---

## 📋 2. Data Structure Visual (JSON Log Model)

As requested, here is the visual representation of how a shipment and its history are linked in the system:

```json
{
  "awb_no": "AWB12345678",
  "shipment_details": {
    "booking_ref_id": "REF99",
    "consignee_name": "John Doe",
    "payment_mode": "COD",
    "cod_amount": 500.00
  },
  "current_status": "Out For Delivery",
  "scan_details_history": [
    {
      "status": "Manifested",
      "location": "Warehouse A",
      "scan_datetime": "2026-02-14 10:00:00",
      "remarks": "Package ready for pickup"
    },
    {
      "status": "In Transit",
      "location": "Transit Hub Hub B",
      "scan_datetime": "2026-02-14 14:00:00",
      "remarks": "On its way to destination"
    },
    {
      "status": "Out For Delivery",
      "location": "City Center",
      "scan_datetime": "2026-02-14 17:00:00",
      "remarks": "Assigned to delivery boy"
    }
  ],
  "db_fix_resolution": "tbl_tracking (New record per scan) -> tbl_bookings (Update last_status)"
}
```

---

## 🛠️ 3. Core Module Logic

### A. Shipment Create (`shipment-create.php`)
- **Action**: Initializes the `tbl_bookings` table.
- **Fields**: AWB, Pincodes, Weight, Dimensions, Courier Partner.
- **Result**: A searchable shipment available in the tracking module.

### B. Status Update (`shipment-status-update.php`)
- **Key Feature**: **Bulk Scan & Update**.
- **Interactive UI**: Shipments are held in a "staged list" where user can review details before hitting "Update All".
- **Real-time Feedback**: Updates are performed asynchronously (AJAX), and the UI highlights success/failure per card.

### C. Tracking API (`api/tracking/create.php`)
- **Logic**:
  - `INSERT INTO tbl_tracking`: Stores the full history (scan type, location, time, remarks).
  - `UPDATE tbl_bookings`: Sets `last_status` to ensure the main table always reflects the latest state.
  - **Duplicate Prevention**: Checks for existing identical scans (same type and time) before inserting.

---

## 📁 4. Database Relationship Diagram

| Table: `tbl_bookings` | | Table: `tbl_tracking` |
|:---|:---:|:---|
| `id` (PK) | ←── (1:N) ──→| `booking_id` (FK) |
| `waybill_no` | | `waybill_no` |
| `last_status` | | `scan_type` (Status) |
| `created_at` | | `scan_location` |
| `updated_at` | | `scan_datetime` |
| | | `remarks` |

---
**Document Status**: ✅ Final Technical Summary  
**Integration Version**: 1.2
