# Shipment Status Update - Quick Reference Guide

## 🎯 What's Included

### ✅ Complete Form Structure
```
┌──────────────────────────────────────────────────────┐
│              SHIPMENT STATUS UPDATE                  │
│   [3 Scanned]        [Clear All]        [← Back]    │
└──────────────────────────────────────────────────────┘

INPUT SECTION:
┌──────────────────────────────────────────────────────┐
│  [  Scan or type AWB Number...  ]  [  Add AWB  ]    │
└──────────────────────────────────────────────────────┘

SHIPMENTS SECTION (Card View):
┌──────────────────────────────────────────────────────┐
│ 📦 Shipment #1                              [Delete] │
├──────────────────────────────────────────────────────┤
│ AWB Number: ABC123456                               │
│ Reference ID: REF-2024-001                          │
│ Courier: Delhivery                                  │
│ Boxes: 5                                            │
│                                                     │
│ Origin: Delhi → Destination: Mumbai                 │
│ Consignor: ABC Logistics                           │
│ Consignee: XYZ Retail                              │
│                                                     │
│ Booking Date: 14/02/2026                           │
│ Status: [IN TRANSIT]    [▼ View History]           │
│                                                     │
│ ┌─ Tracking History (Hidden) ──────────────────┐   │
│ │ (Click ▼ to expand)                          │   │
│ │ • 14/02/2026 10:30 [MANIFESTED] - Delhi Hub   │   │
│ │ • 14/02/2026 14:45 [IN TRANSIT] - Agra       │   │
│ └───────────────────────────────────────────────┘   │
└──────────────────────────────────────────────────────┘

UPDATE FORM (appears when items scanned):
┌──────────────────────────────────────────────────────┐
│  Status: [Select Status ▼]                          │
│  Date: [2026-02-14]                                 │
│  Location: [Optional location...]                   │
│          [Update All (3)]                           │
│  Remarks: [Optional notes...]                       │
└──────────────────────────────────────────────────────┘
```

---

## 📌 Key Components

### 1. SHIPMENT CARDS
Each scanned shipment displays as a professional card:

```
Left Side (AWB Info)          Right Side (Route Info)
├─ AWB Number                 ├─ Origin City
├─ Reference ID               ├─ Destination City
├─ Courier Name               ├─ Consignor Name
└─ No. of Boxes               └─ Consignee Name

Bottom (Status & History)
├─ Booking Date
└─ Current Status + History Toggle
```

### 2. STATUS BADGES (Color-Coded)

| Badge | Color | Use Case |
|:---:|:---:|:---|
| PENDING | 🟠 Orange | Not yet processed |
| NOT PICKED | 🔴 Red | Pickup failed |
| MANIFESTED | 🟣 Purple | Added to shipment list |
| IN TRANSIT | 🔵 Blue | Currently in transit |
| OUT FOR DELIVERY | 🟢 Teal | With delivery agent |
| DELIVERED | ✅ Green | Successfully delivered |
| LOST | ❌ Dark Red | Package lost |
| RTO | 🟡 Amber | Return to origin |

### 3. TRACKING HISTORY
```
┌─ 14/02/2026 10:30 ────────────────────────────┐
│ [MANIFESTED]                                   │
│ 📍 Delhi Hub                                   │
│ _Scanned by: Operator A_                      │
└────────────────────────────────────────────────┘

┌─ 14/02/2026 14:45 ────────────────────────────┐
│ [IN TRANSIT]                                   │
│ 📍 Agra Distribution Center                   │
│ _In transit to destination_                   │
└────────────────────────────────────────────────┘
```

---

## 🚀 How to Use

### STEP 1: ADD SHIPMENTS
```
1. Focus on input field (auto-focused)
2. Scan or type AWB number
3. Press ENTER or click [Add AWB]
4. Shipment card appears below
5. Repeat for more shipments
```

### STEP 2: VIEW DETAILS
```
1. Shipment card shows all details automatically
2. Current status displayed with color badge
3. Click [▼ View History] to see all scans
4. Click [▲ Hide] to collapse history
```

### STEP 3: UPDATE STATUS
```
1. Select new status from dropdown
2. Status date auto-sets to today (editable)
3. Add location if needed (optional)
4. Add remarks if needed (optional)
5. Click [Update All (3)]
6. Confirm in popup
7. See success/error notification
```

### STEP 4: MANAGE ITEMS
```
To remove one:   Click [X] on that card
To remove all:   Click [Clear All] button
To start fresh:  Remove all, then scan new AWBs
```

---

## 📊 Data Flow

```
USER INPUT
    ↓
[Scan AWB] → Validate → Search in DB
    ↓
DISPLAY SHIPMENT
    ↓
[Show Details] → [Show History] → [Update Status]
    ↓
DATABASE UPDATE
    ↓
tbl_tracking: CREATE new scan record
tbl_bookings: UPDATE last_status
    ↓
CONFIRMATION
    ↓
Toast notification + Visual feedback
```

---

## 🎨 Status Colors Quick Reference

```css
.status-badge.pending { background: #fff3e0; color: #F57C00; }
.status-badge.not-picked { background: #fce4ec; color: #C2185B; }
.status-badge.manifested { background: #f3e5f5; color: #7B1FA2; }
.status-badge.in-transit { background: #e3f2fd; color: #1976D2; }
.status-badge.out-for-delivery { background: #e0f2f1; color: #00796B; }
.status-badge.delivered { background: #e8f5e9; color: #388E3C; }
.status-badge.lost { background: #ffebee; color: #C62828; }
.status-badge.rto { background: #fff8e1; color: #F9A825; }
```

---

## 📱 Form Fields

### SEARCH SECTION
| Field | Type | Required | Placeholder |
|:---|:---|:---:|:---|
| Search Input | Text | ✓ | "Scan or type AWB Number and press Enter" |

### STATUS UPDATE SECTION (Bulk)
| Field | Type | Required | Options |
|:---|:---|:---:|:---|
| Update Status | Dropdown | ✓ | Pending, Not Picked, Manifested, In Transit, Out For Delivery, Delivered, LOST, RTO |
| Status Date | Date | ✓ | Today (editable) |
| Location | Text | ✗ | e.g., "Delhi Hub" |
| Remarks | Textarea | ✗ | Any additional notes |

---

## 🔍 Search Functionality

### Supported Search Types:
```
✓ AWB Number:     ABC123456
✓ Reference ID:   REF-2024-001
✓ Booking ID:     12345
```

### Search Results:
- ✓ Exact match only (case-insensitive)
- ✓ Duplicate detection (warns if already scanned)
- ✓ Error handling (clear message if not found)
- ✓ Toast notifications (success/error)

---

## 💾 Database Fields

### What Gets Saved to `tbl_tracking`:

```
booking_id      ← Which shipment
waybill_no      ← AWB number
scan_type       ← Status (Pending, In Transit, etc.)
scan_location   ← Where it was scanned
scan_datetime   ← When it was scanned
status_code     ← Status code
remarks         ← Your notes
raw_response    ← Complete JSON data
created_at      ← Record creation time
```

### What Gets Updated in `tbl_bookings`:

```
last_status     ← Latest status
updated_by      ← Who made the change
updated_at      ← When it was changed
```

---

## ✨ Smart Features

### 🔄 Auto-Features:
- ✓ Auto-focus on search input
- ✓ Auto-set status date to today
- ✓ Auto-clear form after bulk update
- ✓ Auto-hide empty history section
- ✓ Auto-number shipments as you add them

### 🛡️ Validation:
- ✓ Prevent duplicate AWB scans
- ✓ Require status selection
- ✓ Require status date
- ✓ Prevent empty shipment list
- ✓ Check AWB exists in system

### 📢 Notifications:
- ✓ Success messages (green)
- ✓ Warning messages (yellow)
- ✓ Error messages (red)
- ✓ Progress indicators
- ✓ Count badges (scanned items)

---

## 🎯 Common Workflows

### WORKFLOW 1: Update Single Status
```
1. Scan 1 AWB
2. Select new status
3. Click Update (1)
4. Done!
```

### WORKFLOW 2: Batch Processing
```
1. Scan 10 AWBs
2. Select status
3. Add location (hub name)
4. Click Update (10)
5. All 10 updated in one action
```

### WORKFLOW 3: Review History
```
1. Scan AWB
2. Click View History
3. See all previous scans
4. Make decision on next status
5. Update status
```

### WORKFLOW 4: Correct Mistake
```
1. Scan wrong AWB
2. Click [X] to remove
3. Scan correct AWB
4. Continue...
```

---

## 🐛 Troubleshooting

| Problem | Solution |
|:---|:---|
| AWB not found | Check spelling, verify in system |
| "AWB already scanned" | Click [X] to remove, scan again |
| Status not updating | Select status, check date format |
| History not showing | Click [▼ View History], wait for load |
| Form disappeared | Scroll down, it's after shipments |
| Notification didn't appear | Check browser console for errors |

---

## ⌨️ Keyboard Shortcuts

```
ENTER          Scan AWB (same as clicking Add)
TAB            Move between fields
SHIFT+TAB      Move back between fields
ESC            (Close any popups/dropdowns)
```

---

## 📋 Checklist Before Bulk Update

- [ ] All AWBs scanned correctly
- [ ] Status selected from dropdown
- [ ] Date is correct
- [ ] Location entered (if applicable)
- [ ] Remarks added (if needed)
- [ ] Confirmed in popup dialog

---

## 🔗 Related APIs

```
GET  /api/shipment/read.php?length=-1     ← Search shipments
POST /api/tracking/create.php              ← Save status update
GET  /api/tracking/read.php?id=<booking>   ← Get history
```

---

## 📞 Support Info

**Current Version**: 2.0
**Last Updated**: 2026-02-14
**Status**: Production Ready ✅

For issues, contact your admin with:
- Affected AWB number
- Action attempted
- Error message (if any)
- Browser/Device info
