# Own Courier Status Update - Quick Start Guide

## 🎯 What This Does

Allows you to manually update shipment status for own courier shipments. Each update:
- Creates a tracking record (scan/type)
- Updates booking's last_status automatically
- Shows in recent updates sidebar
- Appears in shipments table

## ⚡ Quick Access

**URL:** `http://localhost/steve/shipment-status-update.php`

## 📝 In 3 Steps

### 1️⃣ SEARCH
```
Select: "Booking ID" / "Waybill No" / "Reference ID"
Enter: The value
Click: "Search Shipment" button
```

### 2️⃣ FILL FORM
```
Status:        [Select from dropdown] ⭐ Required
Date & Time:   [Pick from calendar]   ⭐ Required
Location:      [Enter text]           Optional
Remarks:       [Enter text]           Optional
```

### 3️⃣ UPDATE
```
Click: "Update Status" button
Done! ✅ Status updated in both tables
```

## 📊 Status Options

| Status | Use When |
|--------|----------|
| **Pending** | Initial/waiting |
| **Not Picked** | Pickup failed/pending |
| **Manifested** | Added to manifest |
| **In Transit** | On the way |
| **Out For Delivery** | Out with delivery agent |
| **Delivered** | Delivered to customer |
| **LOST** | Shipment lost |
| **RTO** | Return to origin |

## 📋 Form Fields Explained

**Status Dropdown** (Required)
- What happened to the shipment
- Must select from 8 options
- Matches tbl_tracking.scan_type

**Date & Time Picker** (Required)
- When did this status happen
- Defaults to right now
- Format: YYYY-MM-DD HH:MM

**Location Input** (Optional)
- Where is the shipment now
- Examples: "Delhi Hub", "Delivery Truck 42"
- Helps track movement

**Remarks Textarea** (Optional)
- Any notes or instructions
- Examples: "Customer not available", "Damaged packaging"
- Useful for problems

## 🔄 What Happens

1. **Form Submitted** → Sent to `api/tracking/create.php`
2. **Validation** → Checks all required fields
3. **Insert Tracking** → New record in `tbl_tracking`
4. **Update Booking** → `tbl_bookings.last_status` changed
5. **Commit** → Both changes saved together
6. **Refresh UI** → Table, sidebar, form updated
7. **Success Message** → Confirms update

## 💾 Database Updates

### tbl_tracking (New Record)
```
booking_id: 123
waybill_no: DHL2024001
scan_type: "In Transit"
scan_location: "Delhi Hub"
scan_datetime: 2024-01-15 14:30:00
status_code: "In Transit"
remarks: "Package at Delhi hub"
created_by: 1
created_at: 2024-01-15 14:30:00
```

### tbl_bookings (Updated)
```
id: 123
last_status: "In Transit"  ← Changed from previous
updated_at: 2024-01-15 14:30:00
updated_by: 1
```

## 📱 UI Overview

```
┌─────────────────────────────────────────────────┐
│         SEARCH SHIPMENT (Top)                   │
│  [Type Dropdown] [Input Field] [Search Button]  │
└─────────────────────────────────────────────────┘

┌──────────────────────┐  ┌──────────────────────┐
│  SHIPMENT DETAILS    │  │  RECENT UPDATES      │
│  (Left, big)         │  │  (Right, sidebar)    │
│  - All info          │  │  - Last 10 records   │
│  - Current status    │  │  - Auto-refresh      │
└──────────────────────┘  └──────────────────────┘

┌──────────────────────────────────────────────────┐
│  STATUS UPDATE FORM                              │
│  [Status Dropdown] ⭐                            │
│  [Date/Time Picker] ⭐                           │
│  [Location Input]                                │
│  [Remarks Textarea]                              │
│  [Update Button]                                 │
└──────────────────────────────────────────────────┘

┌──────────────────────────────────────────────────┐
│  SHIPMENTS TABLE (Bottom)                        │
│  [Filters: Status, Branch]                       │
│  [All shipments with inline Update buttons]      │
└──────────────────────────────────────────────────┘
```

## ✅ Common Tasks

### Update Status for Single Shipment
```
1. Search by Booking ID
2. Select new status
3. Set date/time
4. Add location (optional)
5. Click Update
```

### Bulk Update Multiple Shipments
```
1. Use table at bottom
2. Click "Update" button on each row
3. Form fills with that shipment
4. Update status
5. Repeat for next shipment
```

### Find Problem Shipments
```
1. Use Status filter: "LOST"
2. See all lost shipments
3. Click Update on one
4. Add remarks
5. Can change status if needed
```

## 🚫 Things to Remember

| ✅ DO | ❌ DON'T |
|-------|----------|
| Select status from dropdown | Type random status value |
| Use accurate date/time | Use future dates |
| Add location for important updates | Forget to fill required fields |
| Add remarks for issues | Add duplicate updates (same time) |
| Check recent updates after saving | Ignore error messages |

## 🐛 Quick Fixes

| Problem | Solution |
|---------|----------|
| "Shipment not found" | Check search value, try different search method |
| "Status is required" | Select a status from dropdown |
| "Date is required" | Pick date & time from calendar |
| "Record already exists" | Use different time (change minute) |
| Table not updating | Refresh page with F5 |

## 📞 Help Reference

| Need | Location |
|------|----------|
| Full docs | `OWN_COURIER_STATUS_UPDATE.md` |
| Step-by-step | `USAGE_GUIDE_STATUS_UPDATE.md` |
| Implementation | `SHIPMENT_STATUS_UPDATE_SUMMARY.md` |
| This guide | `STATUS_UPDATE_QUICK_START.md` |

## 🎯 Key Points

1. **Page:** `shipment-status-update.php`
2. **API:** `api/tracking/create.php`
3. **Updates:** Both `tbl_tracking` AND `tbl_bookings`
4. **Forms:** Must fill Status ⭐ and Date ⭐
5. **Results:** Real-time UI refresh, success message
6. **Table:** Own courier shipments with filters
7. **Sidebar:** Recent updates show tracking history
8. **Validation:** Client-side and server-side checks
9. **Transactions:** Data consistency guaranteed
10. **Mobile:** Responsive, works on all devices

## 🚀 You're Ready!

Open the page and start updating shipment statuses:
```
http://localhost/steve/shipment-status-update.php
```

**Step 1:** Search → **Step 2:** Fill form → **Step 3:** Update ✅

---

**Questions?** Check the full documentation files or contact support.
