# Status Update Page - Quick Test Guide

## ✅ System Ready to Test

### Test Scenario 1: Basic Search & Display
```
1. Go to: shipment-status-update.php
2. Scan or type valid AWB number
3. Expected: Shipment card appears with details
   ├─ Shipment #1 header
   ├─ AWB Number visible
   ├─ Reference ID
   ├─ Courier name
   ├─ Consignee details
   ├─ Origin & Destination
   └─ Current Status badge (colored)
```

### Test Scenario 2: View Tracking History
```
1. After shipment appears
2. Click [▼ View History] button
3. Expected: Tracking timeline expands
   ├─ Shows all previous scans
   ├─ Each scan shows:
   │  ├─ Timestamp
   │  ├─ Status badge
   │  ├─ Location
   │  └─ Remarks
   └─ Button changes to [▲ Hide History]
```

### Test Scenario 3: Update Status
```
1. Scan 1-3 shipments
2. Select status from dropdown
3. Status Date (defaults to today)
4. Add location (optional)
5. Add remarks (optional)
6. Click "Update All (n)"
7. Confirm in popup
8. Expected:
   ├─ Green toast notification
   ├─ Status badge updates
   ├─ Background highlights green
   └─ History refreshes (if visible)
```

### Test Scenario 4: Database Verification
```
After updating status, verify database:

SELECT * FROM tbl_tracking
WHERE booking_id = <booking_id>
ORDER BY scan_datetime DESC;

Expected: New record appears with:
├─ booking_id (correct)
├─ scan_type (new status)
├─ scan_location (if entered)
├─ scan_datetime (current time)
└─ remarks (if entered)

SELECT last_status FROM tbl_bookings
WHERE id = <booking_id>;

Expected: last_status = new status value
```

### Test Scenario 5: Error Handling
```
1. Try to search without entering AWB
   Expected: Input stays focused

2. Try to update without selecting status
   Expected: Warning toast "Please select a status"

3. Try to update with duplicate AWB
   Expected: Warning toast "AWB already scanned"

4. Try search with invalid AWB
   Expected: Error toast "Shipment not found"
```

---

## 🎯 What to Verify

### ✓ Frontend Works
- [ ] Page loads without errors
- [ ] Search input auto-focuses
- [ ] Shipments appear as cards
- [ ] Status badges have colors
- [ ] History toggle works
- [ ] Update form appears
- [ ] Toast notifications show
- [ ] Mobile view responsive

### ✓ API Integration
- [ ] Search finds shipments
- [ ] History loads correctly
- [ ] Updates save successfully
- [ ] Errors display properly

### ✓ Database Integration
- [ ] tbl_tracking inserts work
- [ ] tbl_bookings updates work
- [ ] Duplicates are prevented
- [ ] Data integrity maintained

### ✓ User Experience
- [ ] Form validation works
- [ ] Button states change
- [ ] Feedback is clear
- [ ] No UI freezing

---

## 📋 Expected Behavior

### Search Results
- Exact match by AWB number
- Exact match by Reference ID
- Exact match by Booking ID
- Case-insensitive
- Duplicate detection

### Status Update
- All 8 statuses available
- Date can be edited
- Location optional
- Remarks optional
- Bulk update works
- No partial updates

### Tracking History
- Shows all scans
- Newest first
- Complete details
- Proper formatting
- Lazy loads

---

## 🔧 If Issues Occur

### Issue: Shipment not found
**Check**:
- AWB exists in tbl_bookings
- Spelling is correct
- Use exact value

**Solution**: Verify booking was created first

### Issue: Status not updating
**Check**:
- api/tracking/create.php returns success
- tbl_tracking was updated
- tbl_bookings.last_status changed

**Solution**: Check browser console (F12) for errors

### Issue: History not loading
**Check**:
- api/tracking/read.php returns data
- tbl_tracking has records
- Scans have scan_datetime

**Solution**: Verify at least one status update exists

### Issue: Toast not showing
**Check**:
- showtoastt() function exists
- jQuery is loaded
- No JavaScript errors

**Solution**: Check browser console (F12)

---

## ✨ Success Indicators

You know it's working when:

1. ✅ Search finds shipments instantly
2. ✅ Cards display with all details
3. ✅ Status badges are colored
4. ✅ History expands smoothly
5. ✅ Updates save and show toast
6. ✅ Badge colors update on save
7. ✅ Database records appear
8. ✅ No console errors
9. ✅ Mobile view works
10. ✅ All 8 statuses available

---

## 📊 Performance Indicators

- Search: < 500ms
- History load: < 300ms
- Update: < 200ms
- UI refresh: < 100ms
- No freezing: < 3s max wait

---

## 🐛 Debugging Tips

**Check Console**:
```javascript
F12 → Console tab
Look for errors (red text)
Check network requests (Network tab)
```

**Check Database**:
```sql
SELECT COUNT(*) FROM tbl_tracking;
SELECT * FROM tbl_tracking LIMIT 1;
SELECT * FROM tbl_bookings WHERE id = 12345;
```

**Check APIs**:
```
Try in browser:
- api/shipment/read.php?length=-1
- api/tracking/read.php?id=12345
- Check response JSON
```

---

## 🎯 Test Completion Checklist

- [ ] Can load page
- [ ] Can search shipments
- [ ] Can view details
- [ ] Can toggle history
- [ ] Can update status
- [ ] See success toast
- [ ] Database updated
- [ ] All 8 statuses work
- [ ] Color badges correct
- [ ] Mobile responsive
- [ ] No console errors
- [ ] Form validation works

**All Checked?** → System is READY! ✅

---

## 📞 Support

For issues, check:
1. Browser console (F12) for JavaScript errors
2. Network tab (F12) for API response errors
3. Database for data integrity
4. Documentation for usage

See: **SHIPMENT_STATUS_UPDATE_FIXED.md** for complete details
