# Own Courier Status Update - Step-by-Step Usage Guide

## 🚀 Getting Started

### Access the Page
Open your browser and navigate to:
```
http://localhost/steve/shipment-status-update.php
```

## 📋 Step-by-Step Instructions

### STEP 1: Search for a Shipment

#### Option A: Search by Booking ID
1. Select **"Booking ID"** from "Search By" dropdown
2. Enter the booking ID number (e.g., `123`)
3. Click **"Search Shipment"** button
4. Wait for results to load

#### Option B: Search by Waybill Number
1. Select **"AWB / Waybill No"** from "Search By" dropdown
2. Enter the waybill/AWB number (e.g., `DHL123456789`)
3. Click **"Search Shipment"** button
4. Wait for results to load

#### Option C: Search by Reference ID
1. Select **"Reference ID"** from "Search By" dropdown
2. Enter the reference ID (e.g., `REF-2024-001`)
3. Click **"Search Shipment"** button
4. Wait for results to load

### STEP 2: View Shipment Information

After successful search, you'll see a detailed shipment information table:

**What You'll See:**
| Field | Example |
|-------|---------|
| Booking ID | 456 |
| Waybill No | DHL2024001 |
| Reference ID | REF-001 |
| Consignee | John Doe |
| Phone | 9876543210 |
| Current Status | In Transit (badge) |
| No. of Boxes | 2 |
| Weight | 5 kg |
| Origin | Maharashtra => Mumbai - 400001 |
| Destination | Karnataka => Bangalore - 560001 |
| Date Added | 2024-01-15 10:30 AM |
| Client Name | ABC Courier |

### STEP 3: Update the Status

#### Fill in the Status Update Form:

**1. Select Status** ⭐ (Required)
- Click "Select Update Status" dropdown
- Choose one of:
  - **Pending** - Initial status
  - **Not Picked** - Shipment couldn't be picked up
  - **Manifested** - Added to delivery manifest
  - **In Transit** - On the way to destination
  - **Out For Delivery** - Out with delivery agent
  - **Delivered** - Delivered to consignee
  - **LOST** - Shipment lost
  - **RTO** - Return to origin

**2. Set Date & Time** ⭐ (Required)
- Click "Status Update Date" field
- A calendar picker will appear
- Select the date
- Select the time
- The current date/time is pre-filled by default

**3. Enter Location** (Optional but Recommended)
- Click "Status Location" field
- Enter where the shipment is located
- Examples:
  - "Delhi Hub"
  - "Mumbai Sorting Center"
  - "Delivery Truck #42"
  - "Bangalore Branch Office"

**4. Add Remarks** (Optional)
- Click "Remarks / Instructions" text area
- Add any additional notes
- Examples:
  - "Customer not available, left at neighbor"
  - "Attempted delivery, customer unavailable"
  - "Package damaged, waiting for approval"
  - "Recipient requested delivery on specific date"

### STEP 4: Submit the Update

1. **Review All Fields**
   - Verify status is selected
   - Check date/time is correct
   - Confirm location (if added)

2. **Click "Update Status" Button**
   - Button will show loading animation
   - Wait for success message

3. **Verify Success**
   - Green success message appears at top
   - Recent updates sidebar refreshes with new record
   - Shipment table updates
   - Form fields clear

### STEP 5: View Recent Updates

On the right sidebar, you'll see **"Recent Status Updates"** showing:
- Last 10 tracking records for this shipment
- Date & time of each update
- Status value
- Location (if available)

## 📊 Using the Shipments Table

### View All Own Courier Shipments

At the bottom of the page, there's a table showing all own courier shipments.

**Table Columns:**
```
ID | Waybill | Ref ID | Boxes | To Pay | Date | Status | Weight | Client | Consignor | Consignee | Origin | Destination | Action
```

### Filter Shipments

**By Status:**
1. Click "Status" filter dropdown
2. Select status (Pending, In Transit, Delivered, etc.)
3. Table updates automatically

**By Branch:**
1. Click "Branch" filter dropdown
2. Select branch
3. Table updates automatically

### Quick Update from Table

1. Find the shipment in the table
2. Click the **"Update"** button in the Action column
3. The search form auto-fills with that shipment
4. Form scrolls to top
5. Follow steps 2-4 above

## 💡 Examples

### Example 1: Mark as Picked Up

```
Booking ID: 123
Current Status: Not Picked

ACTION:
- Search by Booking ID: 123
- Select Status: "Manifested"
- Set Date: Today at current time
- Location: "Delhi Hub"
- Remarks: "Package received at Delhi hub"
- Click Update
```

### Example 2: Out for Delivery

```
Booking ID: 456
Current Status: In Transit

ACTION:
- Search by Booking ID: 456
- Select Status: "Out For Delivery"
- Set Date: Today, 10:00 AM
- Location: "Delivery Truck 42"
- Remarks: "Out for delivery in Bangalore"
- Click Update
```

### Example 3: Delivery Attempt Failed

```
Waybill: DHL2024001
Current Status: Out For Delivery

ACTION:
- Search by Waybill: DHL2024001
- Select Status: "Not Picked"
- Set Date: Today at time of attempt
- Location: "Bangalore Delivery Center"
- Remarks: "Customer not available, will retry tomorrow"
- Click Update
```

### Example 4: Delivered

```
Reference ID: REF-001
Current Status: Out For Delivery

ACTION:
- Search by Reference: REF-001
- Select Status: "Delivered"
- Set Date: Today at delivery time
- Location: "Customer location"
- Remarks: "Delivered and signed by customer"
- Click Update
```

## ⚙️ Important Features

### ✅ Auto-Filled Date/Time
- Today's date and current time is automatically filled
- You can change it if needed
- Format: YYYY-MM-DD HH:MM

### ✅ Real-Time Updates
- No page refresh needed
- Table updates automatically
- Sidebar refreshes with new record
- Success message appears

### ✅ Data Validation
- Status is required (must select)
- Date/Time is required
- Location and remarks are optional
- Invalid dates are rejected

### ✅ Duplicate Prevention
- Same booking + status + date/time cannot be added twice
- Prevents accidental duplicate records
- Error message if trying to add duplicate

### ✅ Dual Table Updates
- `tbl_tracking` - New tracking record created
- `tbl_bookings` - Last status updated automatically
- Both happen simultaneously
- If error, both are rolled back

## 🔍 Search Tips

**Lost a Booking ID?** Use Waybill or Reference ID instead

**Format Examples:**
- Booking ID: `123` (just the number)
- Waybill: `DHL2024001` (full waybill number)
- Reference ID: `REF-001` (reference number)

## ✨ Best Practices

### ✅ DO:

1. **Always select a meaningful status**
   - Use exact status values from dropdown
   - Match current shipment state

2. **Set accurate date/time**
   - Use actual time of status update
   - Don't use future dates

3. **Add location information**
   - Helps track shipment movement
   - Provides audit trail
   - Useful for troubleshooting

4. **Add remarks for special cases**
   - Delivery attempt failures
   - Damaged packages
   - Customer requests
   - Any issues or notes

5. **Use consistent location names**
   - "Delhi Hub" vs "Delhi hub" vs "DELHI HUB"
   - Use standard names for locations
   - Helps with reporting

### ❌ DON'T:

1. **Don't skip required fields**
   - Status must be selected
   - Date must be set
   - Form won't submit otherwise

2. **Don't enter wrong status**
   - Can create confusion
   - Makes tracking unreliable
   - Use dropdown values only

3. **Don't add duplicate updates**
   - System prevents exact duplicates
   - Same booking + status + exact time = duplicate
   - Use different times if same status needed

4. **Don't use future dates**
   - Updates should be current or past
   - Future dates indicate errors

5. **Don't forget location for important updates**
   - Delivered, Lost, RTO, Out For Delivery
   - Location helps track movement

## 🆘 Troubleshooting

### Issue: "Shipment not found"

**Cause:** Wrong search value or shipment doesn't exist

**Solution:**
- Double-check booking ID format
- Verify waybill number is correct
- Try different search method
- Check shipment exists in main shipment list

### Issue: "This tracking record already exists"

**Cause:** Exact same status, date, and time already recorded

**Solution:**
- Change the time (use different minute/second)
- Or update a different field (location, remarks)
- Check recent updates to avoid duplicates

### Issue: "Status is required"

**Cause:** Forgot to select status

**Solution:**
- Click dropdown
- Select a status
- Form must have status selected

### Issue: "Date is required"

**Cause:** Date/time field is empty

**Solution:**
- Click date field
- Select date from calendar
- Select time
- Should be pre-filled with current time

### Issue: "Shipment table not loading"

**Cause:** Page loading issue

**Solution:**
- Refresh the page (F5)
- Clear browser cache
- Check browser console (F12)
- Reload page

## 📞 Quick Help

**Page Won't Load?**
- Check URL: `http://localhost/steve/shipment-status-update.php`
- Refresh page (Ctrl+F5)
- Clear cache

**Form Won't Submit?**
- Fill status (required)
- Fill date/time (required)
- Check for error messages
- Verify booking exists

**Can't Find Shipment?**
- Try different search method
- Check shipment table at bottom
- Use inline update button from table

**Data Not Updating?**
- Check success message
- Refresh recent updates sidebar
- Check tracking history

## 📱 Mobile Usage

The page is responsive and works on mobile:

**On Mobile:**
- Use portrait orientation for better view
- Tap dropdown for better selection
- Use calendar picker for date
- Scroll down to see all fields
- Table may be narrower (swipe to scroll)

## 🎯 Common Workflows

### Workflow 1: Daily Status Updates (Start of Day)

1. Open page
2. Filter table by "Pending" status
3. For each shipment:
   - Click "Update" button
   - Select "Manifested"
   - Set time to 9:00 AM
   - Enter location: "Main Hub"
   - Click Update
4. Repeat for all pending shipments

### Workflow 2: Delivery Route (During Day)

1. Open page
2. Filter by "Out For Delivery"
3. For each delivery:
   - Click "Update" button
   - Set time when delivered
   - Select "Delivered"
   - Enter customer location
   - Add any notes
   - Click Update

### Workflow 3: Problem Resolution (Anytime)

1. Search for problematic shipment
2. Check recent updates
3. Assess current status
4. Select new status (Lost, RTO, etc.)
5. Add detailed remarks
6. Update

## 🎓 Training Summary

**Remember:**
1. ✅ Search → View → Update → Verify
2. ✅ Always select status and date
3. ✅ Add location and remarks
4. ✅ Check recent updates to verify
5. ✅ Use table filters to bulk manage shipments

**You're ready to update shipment statuses!** 🚀
