<?php
header('Content-Type: application/json');
require_once '../../config/config.php';
require_once '../../config/middleware.php';

$current_user = get_current_user_info();
$userId = $current_user ? $current_user['id'] : 1;

$designation = $status = '';
$errors = [];

if (isset($_POST['designation']) && !empty($_POST['designation'])) {
    $designation = sanitizeText($_POST['designation']);
} else {
    $errors[] = "Field 'designation' is required";
}

$status = isset($_POST['status']) ? sanitizeText($_POST['status']) : 'active';

if (!empty($errors)) {
    echo json_encode(['status' => 'error', 'message' => implode(', ', $errors)]);
    exit;
}

try {
    $sql = "INSERT INTO tbl_designations (designation, status, created_by, created_at) 
            VALUES (:designation, :status, :created_by, NOW())";

    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':designation', $designation);
    $stmt->bindParam(':status', $status);
    $stmt->bindParam(':created_by', $userId);

    if ($stmt->execute()) {
        echo json_encode(['status' => 'success', 'message' => 'Designation created successfully', 'id' => $pdo->lastInsertId()]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to create designation']);
    }

} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Database error: ' . $e->getMessage()]);
}
