<?php
// download_template.php
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment; filename="Shipment_Bulk_Template.xls"');

$today = date('Y-m-d');
?>
<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel"
    xmlns="http://www.w3.org/TR/REC-html40">

<head>
    <style>
        .required {
            background-color: #ffcccc;
            font-weight: bold;
        }

        .optional {
            background-color: #e0e0e0;
            font-weight: bold;
        }

        td {
            mso-number-format: "\@";
        }

        .example-header {
            background-color: #f8f9fa;
            font-weight: bold;
            text-align: center;
        }
    </style>
</head>

<body>
    <table border="1">
        <tr>
            <!-- 0..4: Origin Info -->
            <th class="required">Branch Name</th>
            <th class="required">Booking Type</th>
            <th class="required">Date (YYYY-MM-DD)</th>
            <th class="optional">Ref ID</th>
            <th class="required">Courier</th>

            <!-- 5..10: Consignor (Manual Flow order: Name, Phone, PIN, Addr, City, State) -->
            <th class="required">Shipper Name</th>
            <th class="required">Shipper Phone</th>
            <th class="required">Shipper Pin</th>
            <th class="required">Shipper Address</th>
            <th class="required">Shipper City</th>
            <th class="required">Shipper State</th>

            <!-- 11..18: Consignee (Manual Flow: Name, Phone, Email, GST, Addr, PIN, City, State) -->
            <th class="required">Consignee Name</th>
            <th class="required">Consignee Phone</th>
            <th class="optional">Consignee Email</th>
            <th class="optional">Consignee GST</th>
            <th class="required">Consignee Address</th>
            <th class="required">Consignee Pin</th>
            <th class="required">Consignee City</th>
            <th class="required">Consignee State</th>

            <!-- 19..21: Package Stats -->
            <th class="required">Payment Mode (Prepaid/COD)</th>
            <th class="optional">COD Amount</th>
            <th class="optional">Product Desc</th>

            <!-- 22..26: Dimensions -->
            <th class="required">Length (cm)</th>
            <th class="required">Width (cm)</th>
            <th class="required">Height (cm)</th>
            <th class="required">Weight (kg/box)</th>
            <th class="required">Boxes</th>

            <!-- 27..30: Extra -->
            <th class="optional">Invoice No</th>
            <th class="optional">Invoice Value</th>
            <th class="optional">Ewaybill No</th>
            <th class="required">Shipping Mode (Surface/Express)</th>
        </tr>

        <!-- Row 1: Prepaid & Express Example -->
        <tr>
            <td>Main Branch</td>
            <td>Forward</td>
            <td><?php echo $today; ?></td>
            <td>PRE-EXP-001</td>
            <td>Delhivery</td>
            <td>ABC Traders</td>
            <td>9876543210</td>
            <td>400001</td>
            <td>123 Merchant Lane</td>
            <td>Mumbai</td>
            <td>Maharashtra</td>
            <td>John Doe</td>
            <td>9123456780</td>
            <td>john@example.com</td>
            <td></td>
            <td>456 Park Avenue</td>
            <td>110001</td>
            <td>Delhi</td>
            <td>Delhi</td>
            <td>Prepaid</td>
            <td>0</td>
            <td>Electronics</td>
            <td>15</td>
            <td>15</td>
            <td>15</td>
            <td>2.5</td>
            <td>1</td>
            <td>INV-101</td>
            <td>1200</td>
            <td></td>
            <td>Express</td>
        </tr>

        <!-- Row 2: COD & Surface Example -->
        <tr>
            <td>Main Branch</td>
            <td>Forward</td>
            <td><?php echo $today; ?></td>
            <td>COD-SUR-002</td>
            <td>Delhivery</td>
            <td>ABC Traders</td>
            <td>9876543210</td>
            <td>400001</td>
            <td>123 Merchant Lane</td>
            <td>Mumbai</td>
            <td>Maharashtra</td>
            <td>Jane Smith</td>
            <td>9888777666</td>
            <td>jane@example.com</td>
            <td>27AADCB1234F1Z1</td>
            <td>789 industrial Area</td>
            <td>560001</td>
            <td>Bangalore</td>
            <td>Karnataka</td>
            <td>COD</td>
            <td>2500</td>
            <td>Hardware</td>
            <td>30</td>
            <td>30</td>
            <td>20</td>
            <td>5.0</td>
            <td>1</td>
            <td>INV-202</td>
            <td>2500</td>
            <td></td>
            <td>Surface</td>
        </tr>

        <!-- Rows 3, 4, 5: MPS Example (3 Boxes in one Shipment) -->
        <!-- Note: Same Ref ID 'MPS-ORD-003' groups them -->
        <tr>
            <td>Main Branch</td>
            <td>Forward</td>
            <td><?php echo $today; ?></td>
            <td>MPS-ORD-003</td>
            <td>Delhivery</td>
            <td>ABC Traders</td>
            <td>9876543210</td>
            <td>400001</td>
            <td>123 Merchant Lane</td>
            <td>Mumbai</td>
            <td>Maharashtra</td>
            <td>Consolidated Store</td>
            <td>9000011111</td>
            <td>contact@store.com</td>
            <td></td>
            <td>Office Complex A</td>
            <td>700001</td>
            <td>Kolkata</td>
            <td>West Bengal</td>
            <td>Prepaid</td>
            <td>0</td>
            <td>Multi Items</td>
            <td>20</td>
            <td>20</td>
            <td>20</td>
            <td>3.0</td>
            <td>1</td>
            <td>INV-303</td>
            <td>5000</td>
            <td></td>
            <td>Surface</td>
        </tr>
        <tr>
            <td>Main Branch</td>
            <td>Forward</td>
            <td><?php echo $today; ?></td>
            <td>MPS-ORD-003</td>
            <td>Delhivery</td>
            <td>ABC Traders</td>
            <td>9876543210</td>
            <td>400001</td>
            <td>123 Merchant Lane</td>
            <td>Mumbai</td>
            <td>Maharashtra</td>
            <td>Consolidated Store</td>
            <td>9000011111</td>
            <td>contact@store.com</td>
            <td></td>
            <td>Office Complex A</td>
            <td>700001</td>
            <td>Kolkata</td>
            <td>West Bengal</td>
            <td>Prepaid</td>
            <td>0</td>
            <td>Multi Items</td>
            <td>10</td>
            <td>10</td>
            <td>10</td>
            <td>1.5</td>
            <td>1</td>
            <td>INV-303</td>
            <td>5000</td>
            <td></td>
            <td>Surface</td>
        </tr>
        <tr>
            <td>Main Branch</td>
            <td>Forward</td>
            <td><?php echo $today; ?></td>
            <td>MPS-ORD-003</td>
            <td>Delhivery</td>
            <td>ABC Traders</td>
            <td>9876543210</td>
            <td>400001</td>
            <td>123 Merchant Lane</td>
            <td>Mumbai</td>
            <td>Maharashtra</td>
            <td>Consolidated Store</td>
            <td>9000011111</td>
            <td>contact@store.com</td>
            <td></td>
            <td>Office Complex A</td>
            <td>700001</td>
            <td>Kolkata</td>
            <td>West Bengal</td>
            <td>Prepaid</td>
            <td>0</td>
            <td>Multi Items</td>
            <td>40</td>
            <td>40</td>
            <td>10</td>
            <td>6.0</td>
            <td>1</td>
            <td>INV-303</td>
            <td>5000</td>
            <td></td>
            <td>Surface</td>
        </tr>
    </table>
</body>

</html>