<?php
require 'config/db.php';

try {
    // Check if package_details column exists in tbl_bookings
    $stmt = $pdo->query("SHOW COLUMNS FROM tbl_bookings LIKE 'package_details'");
    $column = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$column) {
        echo "Column 'package_details' does not exist. Adding it...<br>";
        $pdo->exec("ALTER TABLE tbl_bookings ADD COLUMN package_details TEXT AFTER product_desc");
        echo "Column 'package_details' added successfully.<br>";
    } else {
        echo "Column 'package_details' already exists.<br>";
    }

    // Check for other Consignor fields if needed (shipper_name, etc) 
    // The current tbl_bookings has consignor details?
    // In step 777, I didn't see shipper_name in the INSERT.
    // I should check if tbl_bookings has shipper fields. Default usually uses Pickup Point as shipper.
    // But user wants manual edit. So I need to store them.

    $fields = ['shipper_name', 'shipper_phone', 'shipper_address', 'shipper_topind', 'shipper_city', 'shipper_state'];
    // Note: shipper_pin might be named shipper_pincode.

    // Let's just add shipper_name, shipper_phone, shipper_address, shipper_pin, shipper_city, shipper_state

    $checkFields = [
        'shipper_name' => 'VARCHAR(255)',
        'shipper_phone' => 'VARCHAR(20)',
        'shipper_address' => 'TEXT',
        'shipper_pin' => 'VARCHAR(10)',
        'shipper_city' => 'VARCHAR(100)',
        'shipper_state' => 'VARCHAR(100)'
    ];

    foreach ($checkFields as $field => $type) {
        $stmt = $pdo->query("SHOW COLUMNS FROM tbl_bookings LIKE '$field'");
        if (!$stmt->fetch(PDO::FETCH_ASSOC)) {
            $pdo->exec("ALTER TABLE tbl_bookings ADD COLUMN $field $type AFTER pickup_point_id");
            echo "Added $field<br>";
        }
    }

} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>