<?php
require 'config/db.php';

try {
    // Check if branch_id column exists in tbl_pickup_points
    $stmt = $pdo->query("SHOW COLUMNS FROM tbl_pickup_points LIKE 'branch_id'");
    $column = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$column) {
        echo "Column 'branch_id' does not exist. Adding it...<br>";
        $pdo->exec("ALTER TABLE tbl_pickup_points ADD COLUMN branch_id INT AFTER company_id");
        echo "Column 'branch_id' added successfully.<br>";
    } else {
        echo "Column 'branch_id' already exists.<br>";
    }

    // Check if branch_id column exists in tbl_bookings too, just in case
    $stmt = $pdo->query("SHOW COLUMNS FROM tbl_bookings LIKE 'branch_id'");
    $columnBook = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$columnBook) {
        echo "Column 'branch_id' does not exist in tbl_bookings. Adding it...<br>";
        // Although not critical for the query if we join via pickup_point, good to have for direct association if needed
        //$pdo->exec("ALTER TABLE tbl_bookings ADD COLUMN branch_id INT AFTER company_id"); // commented out unless requested
        echo "Column 'branch_id' missing in tbl_bookings (skipping add for now).<br>";
    } else {
        echo "Column 'branch_id' already exists in tbl_bookings.<br>";
    }

} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>