-- Consignor Management Table
CREATE TABLE IF NOT EXISTS `tbl_consignor` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `branch_id` INT(11) NOT NULL,
    `client_id` INT(11) NOT NULL,
    `name` VARCHAR(200) NOT NULL,
    `email` VARCHAR(150) DEFAULT NULL,
    `contact_no` VARCHAR(20) NOT NULL,
    `alt_contact_no` VARCHAR(20) DEFAULT NULL,
    `gst_number` VARCHAR(50) DEFAULT NULL,
    `address` TEXT NOT NULL,
    `location` VARCHAR(100) DEFAULT NULL,
    `city` VARCHAR(100) DEFAULT NULL,
    `state` VARCHAR(100) DEFAULT NULL,
    `pincode` VARCHAR(20) DEFAULT NULL,
    `status` ENUM('active', 'inactive') DEFAULT 'active',
    `created_by` INT(11) DEFAULT NULL,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_by` INT(11) DEFAULT NULL,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `idx_branch_id` (`branch_id`),
    KEY `idx_client_id` (`client_id`),
    KEY `idx_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Consignee Management Table
CREATE TABLE IF NOT EXISTS `tbl_consignee` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `branch_id` INT(11) NOT NULL,
    `client_id` INT(11) NOT NULL,
    `name` VARCHAR(200) NOT NULL,
    `email` VARCHAR(150) DEFAULT NULL,
    `contact_no` VARCHAR(20) NOT NULL,
    `alt_contact_no` VARCHAR(20) DEFAULT NULL,
    `gst_number` VARCHAR(50) DEFAULT NULL,
    `address` TEXT NOT NULL,
    `location` VARCHAR(100) DEFAULT NULL,
    `city` VARCHAR(100) DEFAULT NULL,
    `state` VARCHAR(100) DEFAULT NULL,
    `pincode` VARCHAR(20) DEFAULT NULL,
    `status` ENUM('active', 'inactive') DEFAULT 'active',
    `created_by` INT(11) DEFAULT NULL,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_by` INT(11) DEFAULT NULL,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `idx_branch_id` (`branch_id`),
    KEY `idx_client_id` (`client_id`),
    KEY `idx_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
