CREATE TABLE IF NOT EXISTS `tbl_pickup_points` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) DEFAULT NULL COMMENT 'Link to company',
  `branch_id` int(11) DEFAULT NULL COMMENT 'Link to branch',
  `pickup_point_code` varchar(50) DEFAULT NULL COMMENT 'Non-unique pickup point identifier',
  `name` varchar(255) NOT NULL COMMENT 'Warehouse Name',
  `registered_name` varchar(255) DEFAULT NULL COMMENT 'Registered Account Name',
  `phone` varchar(20) NOT NULL COMMENT 'Contact Number',
  `email` varchar(100) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `pin` varchar(10) NOT NULL,
  `country` varchar(100) DEFAULT NULL,
  `return_address` text NOT NULL,
  `return_city` varchar(100) DEFAULT NULL,
  `return_pin` varchar(10) DEFAULT NULL,
  `return_state` varchar(100) DEFAULT NULL,
  `return_country` varchar(100) DEFAULT NULL,
  `courier_id` int(11) DEFAULT NULL COMMENT 'Link to courier partner if applicable',
  `delhivery_synced` tinyint(1) DEFAULT 0 COMMENT 'Whether synced with Delhivery API',
  `delhivery_response` text DEFAULT NULL COMMENT 'Last Delhivery API response',
  `status` enum('active','inactive') NOT NULL DEFAULT 'active',
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_by` int(11) DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_company_id` (`company_id`),
  KEY `idx_branch_id` (`branch_id`),
  KEY `idx_courier_id` (`courier_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
