<?php
require_once 'header.php';

// Get user information from session
$user_id = $_SESSION['user_id'];
$user_name = $_SESSION['user_name'] ?? 'Guest User';
$user_email = $_SESSION['user_email'] ?? '';
$user_image = isset($_SESSION['user_image']) && !empty($_SESSION['user_image'])
    ? $_SESSION['user_image']
    : 'assets/images/users/default-avatar.png';
?>

<body>
    <!-- Begin page -->
    <div class="wrapper">
        <?php require_once 'sidebar.php'; ?>
        <?php require_once 'topbar.php'; ?>

        <div class="content-page">
            <div class="content">
                <div class="">

                    <!-- Page Title -->
                    <div class="py-3 d-flex align-items-sm-center flex-sm-row flex-column">
                        <div class="flex-grow-1">
                            <h4 class="fs-18 fw-semibold m-0">
                                <i class="ti ti-user-circle me-1"></i> User Profile
                            </h4>
                        </div>
                    </div>

                    <div class="row">
                        <!-- Profile Card -->
                        <div class="col-lg-4">
                            <div class="card">
                                <div class="card-body text-center">
                                    <div class="position-relative d-inline-block mb-3">
                                        <img src="<?php echo htmlspecialchars($user_image); ?>"
                                             class="rounded-circle avatar-xl"
                                             alt="user-image"
                                             id="profileImagePreview"
                                             onerror="this.src='assets/images/users/default-avatar.png'">
                                        <button type="button" class="btn btn-sm btn-soft-primary position-absolute bottom-0 end-0 rounded-circle btn-icon" data-bs-toggle="modal" data-bs-target="#uploadImageModal">
                                            <i class="ti ti-camera"></i>
                                        </button>
                                    </div>
                                    <h5 class="mb-1"><?php echo htmlspecialchars($user_name); ?></h5>
                                    <p class="text-muted mb-3"><?php echo htmlspecialchars($user_email); ?></p>

                                    <div class="row text-start">
                                        <div class="col-12 mb-2">
                                            <div class="d-flex align-items-center">
                                                <i class="ti ti-phone me-2 text-muted"></i>
                                                <span class="text-muted" id="display_phone">Not set</span>
                                            </div>
                                        </div>
                                        <div class="col-12 mb-2">
                                            <div class="d-flex align-items-center">
                                                <i class="ti ti-briefcase me-2 text-muted"></i>
                                                <span class="text-muted" id="display_role">Not set</span>
                                            </div>
                                        </div>
                                        <div class="col-12 mb-2">
                                            <div class="d-flex align-items-center">
                                                <i class="ti ti-building me-2 text-muted"></i>
                                                <span class="text-muted" id="display_department">Not set</span>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="d-flex align-items-center">
                                                <i class="ti ti-map-pin me-2 text-muted"></i>
                                                <span class="text-muted" id="display_branch">Not set</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Edit Profile Form -->
                        <div class="col-lg-8">
                            <div class="card">
                                <div class="card-body">
                                    <h5 class="mb-3 fw-semibold">Edit Profile Information</h5>
                                    <form id="profileForm">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Full Name <span class="text-danger">*</span></label>
                                                <input type="text" class="form-control form-control-sm" id="name" name="name" required>
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Email Address <span class="text-danger">*</span></label>
                                                <input type="email" class="form-control form-control-sm" id="email" name="email" required>
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Phone Number</label>
                                                <input type="text" class="form-control form-control-sm" id="phone" name="phone">
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Address</label>
                                                <input type="text" class="form-control form-control-sm" id="address" name="address">
                                            </div>
                                            <div class="col-12">
                                                <button type="submit" class="btn btn-sm btn-soft-primary">
                                                    <i class="ti ti-device-floppy me-1"></i> Save Changes
                                                </button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>

                            <!-- Activity Log -->
                            <div class="card">
                                <div class="card-body">
                                    <h5 class="mb-3 fw-semibold">Recent Activity</h5>
                                    <div class="table-responsive">
                                        <table class="table table-sm table-hover">
                                            <thead>
                                                <tr>
                                                    <th>Activity</th>
                                                    <th>Date & Time</th>
                                                    <th>IP Address</th>
                                                </tr>
                                            </thead>
                                            <tbody id="activityLog">
                                                <tr>
                                                    <td colspan="3" class="text-center text-muted">
                                                        Loading activity log...
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

            <?php require_once 'footer.php'; ?>

            <!-- Upload Image Modal -->
            <div class="modal fade" id="uploadImageModal" tabindex="-1">
                <div class="modal-dialog modal-sm">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Upload Profile Picture</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <div class="modal-body">
                            <form id="uploadImageForm">
                                <div class="mb-3">
                                    <label class="form-label">Choose Image</label>
                                    <input type="file" class="form-control form-control-sm" id="profileImage" name="profile_image" accept="image/*" required>
                                    <small class="text-muted">Max size: 2MB. Formats: JPG, PNG, GIF</small>
                                </div>
                                <button type="submit" class="btn btn-sm btn-soft-primary w-100">
                                    <i class="ti ti-upload me-1"></i> Upload
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <script src="assets/plugins/jquery/jquery.min.js"></script>
            <script>
                $(document).ready(function() {
                    // Load user profile data
                    loadProfileData();
                    loadActivityLog();

                    // Profile form submission
                    $('#profileForm').on('submit', function(e) {
                        e.preventDefault();

                        $.ajax({
                            url: 'api/user/update-profile.php',
                            type: 'POST',
                            data: $(this).serialize(),
                            dataType: 'json',
                            success: function(response) {
                                if (response.status === 'success') {
                                    showtoastt(response.message, 'success');
                                    loadProfileData();
                                } else {
                                    showtoastt(response.message, 'error');
                                }
                            },
                            error: function() {
                                showtoastt('Error updating profile', 'error');
                            }
                        });
                    });

                    // Image upload form
                    $('#uploadImageForm').on('submit', function(e) {
                        e.preventDefault();

                        var formData = new FormData(this);

                        $.ajax({
                            url: 'api/user/upload-image.php',
                            type: 'POST',
                            data: formData,
                            processData: false,
                            contentType: false,
                            dataType: 'json',
                            success: function(response) {
                                if (response.status === 'success') {
                                    showtoastt(response.message, 'success');
                                    $('#profileImagePreview').attr('src', response.image_url);
                                    $('#uploadImageModal').modal('hide');
                                    $('#uploadImageForm')[0].reset();
                                } else {
                                    showtoastt(response.message, 'error');
                                }
                            },
                            error: function() {
                                showtoastt('Error uploading image', 'error');
                            }
                        });
                    });

                    function loadProfileData() {
                        $.ajax({
                            url: 'api/user/get-profile.php',
                            type: 'GET',
                            dataType: 'json',
                            success: function(response) {
                                if (response.status === 'success') {
                                    var data = response.data;
                                    $('#name').val(data.name || '');
                                    $('#email').val(data.email || '');
                                    $('#phone').val(data.phone || '');
                                    $('#address').val(data.address || '');

                                    $('#display_phone').text(data.phone || 'Not set');
                                    $('#display_role').text(data.role || 'Not set');
                                    $('#display_department').text(data.department || 'Not set');
                                    $('#display_branch').text(data.branch || 'Not set');
                                }
                            }
                        });
                    }

                    function loadActivityLog() {
                        $.ajax({
                            url: 'api/user/get-activity-log.php',
                            type: 'GET',
                            dataType: 'json',
                            success: function(response) {
                                if (response.status === 'success') {
                                    var html = '';
                                    if (response.data.length > 0) {
                                        response.data.forEach(function(item) {
                                            html += '<tr>';
                                            html += '<td>' + item.activity + '</td>';
                                            html += '<td>' + item.datetime + '</td>';
                                            html += '<td>' + item.ip_address + '</td>';
                                            html += '</tr>';
                                        });
                                    } else {
                                        html = '<tr><td colspan="3" class="text-center text-muted">No activity found</td></tr>';
                                    }
                                    $('#activityLog').html(html);
                                }
                            }
                        });
                    }
                });
            </script>
        </div>
    </div>
</body>

<style>
    .form-control-sm, .form-select-sm {
        padding: 0.25rem 0.5rem !important;
        font-size: 13px !important;
    }

    .table-sm th, .table-sm td {
        padding: 5px !important;
        font-size: 13px;
    }
</style>

</html>
